package com.bxm.localnews.user.account;

import com.bxm.localnews.user.param.GoldFlowParam;
import com.bxm.localnews.user.vo.FlowDetail;
import com.bxm.localnews.user.vo.GoldFlow;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhaoyadong 2019/3/5 22:12
 * @desc
 */
public interface GoldFlowService {

    /**
     * 添加金币流水
     */
    int addGoldFlow(GoldFlow goldFlow);

    /**
     * 添加金币流水【批量】
     */
    void addGoldFlow(List<GoldFlow> goldFlow);

    /**
     * 获取用户金币流水
     */
    List<GoldFlow> getUserGoldFlow(GoldFlowParam goldFlowParam);

    /**
     * 获取昨日的金币
     */
    BigDecimal getYesterdayGold(Long userId);

    /**
     * 获取金币流水
     */
    List<FlowDetail> listGoldFlow(Long userId);

    /**
     * 根据帖子id获取流水金币数
     */
    Integer countGoldByPostId(Long postId, Long userId);
}
