package com.bxm.localnews.user.account;

import com.bxm.localnews.user.dto.AccountIncomeDTO;
import com.bxm.localnews.user.vo.UserAmount;

/**
 * 用户账号金额相关的接口
 */
public interface UserAmountService {

    /**
     * 获取用户账号
     */
    UserAmount findAmountByUserId(Long userId);

    /**
     * 获取用户现金收益相关数据与流水类型定义
     * @param userId 查询的用户ID
     * @return 用户现金与流水类型定义
     */
    AccountIncomeDTO getCashIncome(Long userId);
}
