package com.bxm.localnews.user.account.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.user.account.AccountService;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.domain.PointOrderMapper;
import com.bxm.localnews.user.domain.UserAccountMapper;
import com.bxm.localnews.user.enums.DeductPointStatusEnum;
import com.bxm.localnews.user.enums.GoldEnum;
import com.bxm.localnews.user.enums.GoldFlowTypeEnum;
import com.bxm.localnews.user.param.AccountGoldParam;
import com.bxm.localnews.user.param.DeductPointParam;
import com.bxm.localnews.user.param.StoreNeceParam;
import com.bxm.localnews.user.vo.PointOrder;
import com.bxm.localnews.user.vo.UserAccount;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/3/14 20:51
 * @desc
 */
@Slf4j
@Service
public class AccountServiceImpl implements AccountService {

    @Resource
    private UserAccountMapper userAccountMapper;

    @Resource
    private PointOrderMapper pointOrderMapper;

    @Resource
    private UserAccountService userAccountService;

    @Override
    public BigDecimal selectGoldByUserId(StoreNeceParam storeNeceParam) {
        return selectUsableGoldByUserId(Long.valueOf(storeNeceParam.getAppUid()));
    }

    @Override
    public Boolean deductUserGold(DeductPointParam deductPointParam) {
        //保存订单记录
        PointOrder pointOrder = addPointOrder(deductPointParam);

        //获取用户金币
        BigDecimal userBalance = selectUsableGoldByUserId(Long.valueOf(deductPointParam.getAppUid()));

        //比较扣除的金币
        BigDecimal deductPoint = new BigDecimal(deductPointParam.getPoint().longValue());
        if (userBalance.compareTo(deductPoint) < 0) {
            return Boolean.FALSE;
        }
        log.debug("扣除金币传入的参数:[{}]", JSON.toJSONString(deductPointParam));
        AccountGoldParam param = new AccountGoldParam(Long.valueOf(deductPointParam.getAppUid()),
            GoldEnum.CONSUME_GOLD.name(), false, Math.abs(deductPoint.intValue()), pointOrder.getId(),
            GoldFlowTypeEnum.EXCHANGE_GOODS.getName());

        userAccountService.addGold(param);
        return true;
    }

    @Override
    public void deductConfirmUserGold(DeductPointParam deductPointParam) {
        //获取订单信息
        PointOrder pointOrder = pointOrderMapper.getPointOrder(Long.valueOf(deductPointParam.getAppUid()),
            deductPointParam.getOrderNum());

        if (pointOrder != null) {
            String status = DeductPointStatusEnum.getStatusByStatus(deductPointParam.getStatus());
            if (DeductPointStatusEnum.FAIL.getStatus().equals(status)) {
                //返还用户金币
                log.info("用户[{}]积分商城金币退回.......", deductPointParam.getAppUid());
                BigDecimal returnGold = new BigDecimal("-" + pointOrder.getDeductBalance());
                AccountGoldParam param = new AccountGoldParam(Long.valueOf(deductPointParam.getAppUid()),
                    GoldEnum.USABLE_GOLD.name(), false, returnGold.intValue(),
                    pointOrder.getId(),
                    GoldFlowTypeEnum.STORE_ADD_BALANCE.getName());
                userAccountService.addGold(param);
            }

            //更新订单信息
            pointOrder.setUpdateTime(new Date());
            pointOrder.setStatus(deductPointParam.getStatus());
            pointOrderMapper.updateByPrimaryKeySelective(pointOrder);
        }
    }

    @Override
    public void addUserGold(DeductPointParam deductPointParam) {
        //保存订单记录
        PointOrder pointOrder = addPointOrder(deductPointParam);

        //更新用户金币
        BigDecimal addPoint = new BigDecimal(deductPointParam.getPoint().longValue());
        AccountGoldParam param = new AccountGoldParam(Long.valueOf(deductPointParam.getAppUid()),
            GoldEnum.USABLE_GOLD.name(), true, addPoint.intValue(),
            pointOrder.getId(),
            GoldFlowTypeEnum.STORE_ADD_BALANCE.getName());
        userAccountService.addGold(param);
    }

    @Override
    public BigDecimal selectUsableGoldByUserId(Long userId) {
        UserAccount userAccount = userAccountMapper.getUserAccount(userId);
        if (null != userAccount) {
            BigDecimal usableGold = BigDecimal.valueOf(userAccount.getUsableGold());
            if (usableGold != null && usableGold.compareTo(BigDecimal.ZERO) > 0) {
                return usableGold;
            } else {
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    /**
     * 添加订单记录
     */
    private PointOrder addPointOrder(DeductPointParam deductPointParam) {
        PointOrder pointOrder = new PointOrder();
        pointOrder.setBxmOrderNo(deductPointParam.getOrderNum());
        pointOrder.setOrderNo(deductPointParam.getAppOrderNum());
        pointOrder.setUserId(Long.valueOf(deductPointParam.getAppUid()));
        pointOrder.setDeductBalance(deductPointParam.getPoint().longValue());
        pointOrder.setDescription(deductPointParam.getDescription());
        pointOrder.setStatus(deductPointParam.getStatus());
        pointOrder.setCreateTime(new Date());
        pointOrderMapper.insertSelective(pointOrder);

        return pointOrder;
    }
}
