package com.bxm.localnews.user.account.impl.handler;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.enums.AccountActionEnum;

import java.util.List;

/**
 * 账号动作处理 具体的账号动作详见 {@link com.bxm.localnews.user.enums.AccountActionEnum}
 *
 * @author liujia
 * @date 2020/05/04 10:50
 */
public interface IAccountActionHandler {

    /**
     * 对账号进行对应的逻辑处理
     *
     * @param context 上下文对象
     */
    void handle(AccountActionContext context);

    /**
     * 当前处理器支持处理的账号动作
     *
     * @return 支持的处理动作
     */
    AccountActionEnum support();

    /**
     * 当前处理动作需要使用到的验证规则
     *
     * @return 验证规则列表
     */
    List<Class<? extends IRule>> bindRules();

    /**
     * 是否转化类型的处理器
     * 转化类型的处理器：账号不同属性之前的转化，不涉及账号金币或现金的总量增加或减少
     * 转化类型的流水不会显示给用户
     *
     * @return true表示当前处理器为转化类型的处理器
     */
    default boolean isConvertHandler() {
        return false;
    }
}
