package com.bxm.localnews.user.account.impl.handler.cash;

import com.bxm.localnews.user.account.CashFlowService;
import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.handler.AbstractAccountActionHandler;
import com.bxm.localnews.user.exception.UserAccountException;
import com.bxm.localnews.user.vo.CashFlow;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;

/**
 * 现金的抽象处理器
 * 增加了现金流水记录功能
 *
 * @author liujia
 * @date 2020/05/06 19:39
 */
public abstract class AbstractCashAccountActionHandler extends AbstractAccountActionHandler {
    @Autowired
    protected CashFlowService cashFlowService;

    @Override
    protected void saveFlow(AccountActionContext context) {
        CashFlow cashFlow = buildCashFlow(context);

        if (isConvertHandler()) {
            cashFlow.setConvertType(support().name());
        }

        saveCashFlow(context, cashFlow);
    }

    private CashFlow buildCashFlow(AccountActionContext context) {
        CashFlow cashFlow = new CashFlow();
        cashFlow.setUserId(context.getUserId());

        if (isConsume()) {
            cashFlow.setAmount(context.getAmount().negate());
        } else {
            cashFlow.setAmount(context.getAmount());
        }
        cashFlow.setRelationId(context.getOriginParam().getRelationId());
        cashFlow.setRemark(context.getOriginParam().getRemark());
        if (null != context.getOriginParam().getCashFlowType()) {
            cashFlow.setType(context.getOriginParam().getCashFlowType().name());
        }

        return cashFlow;
    }

    private void saveCashFlow(AccountActionContext context, CashFlow cashFlow) {
        cashFlowService.addCashFlow(cashFlow);
        context.putCashFlow(context.getUserId(), cashFlow);
    }

    BigDecimal add(BigDecimal first, BigDecimal second) {
        if (first == null) {
            first = BigDecimal.ZERO;
        }
        if (second == null) {
            second = BigDecimal.ZERO;
        }

        return first.add(second);
    }

    BigDecimal sub(BigDecimal first, BigDecimal second) {
        if (first == null) {
            first = BigDecimal.ZERO;
        }
        if (second == null) {
            second = BigDecimal.ZERO;
        }

        BigDecimal subtract = first.subtract(second);

        if (subtract.compareTo(BigDecimal.ZERO) < 0) {
            throw new UserAccountException("扣除数量不足,原数值：" + first + ",扣除数值：" + second, false);
        }

        return subtract;
    }

    /**
     * 当前操作是否为扣除，为了兼容老的处理逻辑：
     * 根据流水值的正负来显示新增还是使用
     *
     * @return true：表示为消费（扣除）金币
     */
    boolean isConsume() {
        return false;
    }
}
