package com.bxm.localnews.user.account.impl.handler.cash;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.vo.UserAccount;
import org.springframework.stereotype.Component;

import java.util.List;

import static com.bxm.localnews.user.enums.CashFlowTypeEnum.INVITE_VIP;

/**
 * 增加用户可提现金额
 * @author liujia
 * @date 2020/05/04 18:46
 */
@Component
public class AddDrawableCashAccountActionHandler extends AbstractCashAccountActionHandler {
    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        //可提现金额增加
        storage.setDrawableCash(add(source.getDrawableCash(), context.getAmount()));

        //总赏金增加
        storage.setTotalCash(add(source.getTotalCash(), context.getAmount()));

        //累计结算增加
        storage.setSettledCash(add(source.getSettledCash(), context.getAmount()));

        //如果是开卡收益，则记录开卡收益
        if (INVITE_VIP.equals(context.getOriginParam().getCashFlowType())) {
            storage.setInviteVipCash(add(source.getInviteVipCash(), context.getAmount()));
        } else {
            //剩余的则记录为其他
            storage.setOtherCash(add(source.getOtherCash(), context.getAmount()));
        }
    }

    @Override
    public AccountActionEnum support() {
        return AccountActionEnum.ADD_DRAWABLE_CASH;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return null;
    }
}
