package com.bxm.localnews.user.account.impl.handler.cash;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.support.UserRankService;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

import static com.bxm.localnews.user.constant.RedisConfig.HAS_NEW_SAVE_CASH_EVENT_CACHE;

/**
 * 增加用户的省钱金额
 *
 * @author wzy
 * @date 2020/8/7 11:58
 **/
@Component
public class AddSaveCashAccountActionHandler extends AbstractCashAccountActionHandler {

    @Resource
    private RedisSetAdapter redisSetAdapter;

    @Resource
    private UserRankService userRankService;

    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        //增加省钱金额
        storage.setSaveCash(add(source.getSaveCash(), context.getAmount()));
    }

    @Override
    public AccountActionEnum support() {
        return AccountActionEnum.ADD_SAVE_CASH;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return null;
    }

    @Override
    protected void afterPost(AccountActionContext context) {
        super.afterPost(context);
        // 写入完成后，触发省钱金额的额外逻辑，
        // 1.给用户下次访问主页增加动效显示
        redisSetAdapter.add(HAS_NEW_SAVE_CASH_EVENT_CACHE, context.getUserId());

        // 2.重新加载用户的省钱排行榜
        userRankService.reloadUserSaveCashRank(context.getUserId());

    }

    @Override
    public boolean isConvertHandler() {
        return true;
    }
}
