package com.bxm.localnews.user.account.impl.handler.cash;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.vo.UserAccount;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 增加用户已提现金额
 * @author liujia
 * @date 2020/05/04 18:46
 */
@Component
public class AddWithdrawlCashAccountActionHandler extends AbstractCashAccountActionHandler {
    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        //提现中的金额扣除
        storage.setWithdrawalOfCash(sub(source.getWithdrawalOfCash(), context.getAmount()));

        //已提现金额增加
        storage.setWithdrawalCash(add(source.getWithdrawalCash(), context.getAmount()));
    }

    @Override
    public AccountActionEnum support() {
        return AccountActionEnum.ADD_WITHDRAWAL_CASH;
    }

    @Override
    public boolean isConvertHandler() {
        return true;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return null;
    }
}
