package com.bxm.localnews.user.account.impl.handler.cash;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.vo.UserAccount;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 失败退回，将已提现金额转化为可提现金额
 *
 * @author liujia
 * @date 2020/05/04 18:29
 */
@Component
public class FailWithdrawalAccountActionHandler extends AbstractCashAccountActionHandler {
    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        //提现中金额扣除
        storage.setWithdrawalOfCash(sub(source.getWithdrawalOfCash(), context.getAmount()));

        //可提现金额增加
        storage.setDrawableCash(add(source.getDrawableCash(), context.getAmount()));
    }

    @Override
    public boolean isConvertHandler() {
        return false;
    }

    @Override
    public AccountActionEnum support() {
        return AccountActionEnum.FAIL_WITHDRAWAL;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return null;
    }
}
