package com.bxm.localnews.user.account.impl.handler.cash;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.vo.UserAccount;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 购物佣金结算，从待结算变更为可提现
 * @author liujia
 * @date 2020/05/04 18:46
 */
@Component
public class RebateSettleCashAccountActionHandler extends AbstractCashAccountActionHandler {
    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        //待结算金额扣除
        storage.setNoSettlementCash(sub(source.getNoSettlementCash(), context.getAmount()));
        //已结算增加
        storage.setSettledCash(add(source.getSettledCash(), context.getAmount()));
        //可提现增加
        storage.setDrawableCash(add(source.getDrawableCash(), context.getAmount()));
    }

    @Override
    public boolean isConvertHandler() {
        // 佣金正式结算时，显示到流水中
        return false;
    }

    @Override
    public AccountActionEnum support() {
        return AccountActionEnum.REBATE_SETTLE;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return null;
    }
}
