package com.bxm.localnews.user.account.impl.handler.cash;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.account.impl.rule.StabilizeCashEnoughRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.vo.UserAccount;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 永久赏金转为可提现赏金
 * @author liujia
 * @date 2020/05/04 18:01
 */
@Component
public class Stabilize2DrawableAccountActionHandler extends AbstractCashAccountActionHandler {
    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        //永久金额扣除
        storage.setStabilizeCash(sub(source.getStabilizeCash(), context.getAmount()));
        //可提现金额增加
        storage.setDrawableCash(add(source.getDrawableCash(), context.getAmount()));
    }

    @Override
    public boolean isConvertHandler() {
        return true;
    }

    @Override
    public AccountActionEnum support() {
        return AccountActionEnum.STABILIZE_TO_DRAWABLE;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return Lists.newArrayList(StabilizeCashEnoughRule.class);
    }
}
