package com.bxm.localnews.user.account.impl.handler.cash;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.account.impl.rule.TempCashEnoughRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.vo.UserAccount;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 临时金额转化为可提现金额
 * @author liujia
 * @date 2020/05/04 18:27
 */
@Component
public class TempToDrawableAccountActionHandler extends AbstractCashAccountActionHandler {
    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        //临时金额扣除
        storage.setTempCash(sub(source.getTempCash(), context.getAmount()));
        //可提现金额增加
        storage.setDrawableCash(add(source.getDrawableCash(), context.getAmount()));
    }

    @Override
    public boolean isConvertHandler() {
        return true;
    }

    @Override
    public AccountActionEnum support() {
        return AccountActionEnum.TEMP_TO_DRAWABLE;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return Lists.newArrayList(TempCashEnoughRule.class);
    }
}
