package com.bxm.localnews.user.account.impl.handler.gold;

import com.bxm.localnews.user.account.GoldFlowService;
import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.handler.AbstractAccountActionHandler;
import com.bxm.localnews.user.vo.GoldFlow;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 金币账号信息操作的抽象类
 * 增加了金币流水记录功能
 * @author liujia
 * @date 2020/05/06 19:47
 */
public abstract class AbstractGoldAccountActionHandler extends AbstractAccountActionHandler {

    @Autowired
    protected GoldFlowService goldFlowService;

    @Override
    protected void saveFlow(AccountActionContext context) {
        //增加金币流水
        GoldFlow goldFlow = buildGoldFlow(context);
        saveGoldFlow(context, goldFlow);
    }

    private GoldFlow buildGoldFlow(AccountActionContext context) {
        GoldFlow goldFlow = new GoldFlow();

        if (isConsume()) {
            goldFlow.setAmount(Math.negateExact(context.getGoldNum()));
        } else {
            goldFlow.setAmount(context.getGoldNum());
        }
        goldFlow.setUserId(context.getUserId());
        goldFlow.setContent(context.getOriginParam().getContent());
        goldFlow.setRemark(context.getOriginParam().getRemark());
        goldFlow.setReason(context.getOriginParam().getReason());
        if (null != context.getOriginParam().getGoldFlowType()) {
            goldFlow.setType(context.getOriginParam().getGoldFlowType().getName());

            //内容如果为空，则根据流水类型获取备注
            if (StringUtils.isBlank(goldFlow.getContent())) {
                goldFlow.setContent(context.getOriginParam().getGoldFlowType().getDesc());
            }
        }

        goldFlow.setRelationId(context.getOriginParam().getRelationId());

        return goldFlow;
    }

    private void saveGoldFlow(AccountActionContext context, GoldFlow goldFlow) {
        goldFlowService.addGoldFlow(goldFlow);
        context.putGoldFlow(goldFlow.getUserId(), goldFlow);
    }

    /**
     * 当前操作是否为扣除，为了兼容老的处理逻辑：
     * 根据流水值的正负来显示新增还是使用
     * @return true：表示为消费（扣除）金币
     */
    boolean isConsume() {
        return false;
    }
}
