package com.bxm.localnews.user.account.impl.rule;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;

/**
 * 账号处理校验规则接口 账号处理过程中的限制条件均在此接口的实现类中
 * 比如：
 * 控制用户每日可获取的金币上限
 * 控制每日提现上限
 * @author liujia
 * @date 2020/05/04 10:41
 */
public interface IRule {

    /**
     * 执行规则
     * @param context 上下文
     * @return 执行结果，true表示验证通过
     */
    boolean apply(AccountActionContext context);

    /**
     * 规则验证失败的情况下是否允许重试，默认直接失败
     * 如果验证可能涉及到锁或资源竞争，可以允许重试
     * @return true表示规则验证失败时进入重试
     */
    default boolean retryOnFailed() {
        return false;
    }
}
