package com.bxm.localnews.user.account.impl.rule;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import org.springframework.stereotype.Component;

/**
 * 判断用户的临时现金是否足够
 * @author liujia
 * @date 2020/05/04 17:21
 */
@Component
public class TempCashEnoughRule implements IRule {
    @Override
    public boolean apply(AccountActionContext context) {
        return context.getAmount().compareTo(context.getAccount().getTempCash()) <= 0;
    }
}
