package com.bxm.localnews.user.attribute;

import com.bxm.localnews.user.param.PushParam;

public interface UserAttributeService {

    /**
     * 批量更新用户的点赞数
     */
    Boolean updateUserLikeNum(Long userId);

    /**
     * 给{userId}增加关注数 给{targetUserId}增加粉丝数 重新加载两个用户的缓存
     *
     * @param userId       增加关注数的用户
     * @param targetUserId 增加粉丝数的用户
     * @param isAdd        true:增加，false：扣除
     */
    void addUserFollowCount(Long userId, Long targetUserId, boolean isAdd);

    /**
     * 根据用户id更新点赞数
     */
    Boolean updateUserLikeNumByUserId(Long userId);

    /**
     * 帖子、评论数+1
     */
    Boolean addPostReplyNum(Long userId, Integer type);

    /**
     * 更新用户已领取红包
     */
    Boolean updateUserReceiveRedPacket(Long userId);

    /**
     * 保存推送信息
     */
    void savePush(PushParam pushParam);

    /**
     * 用户邀请人数+1
     *
     * @param userId 用户ID
     */
    void addInviteNum(Long userId);
}
