package com.bxm.localnews.user.attribute;

import com.bxm.localnews.user.param.UserFollowParam;
import com.bxm.localnews.user.vo.UserFollow;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.List;

public interface UserFollowService {

    /**
     * 判断是否关注
     */
    Boolean isFollowed(Long currentUserId, Long targetUserId);

    /**
     * 判断用户是否关注了集合中的用户
     * @param currentUserId
     * @param targetUserIds
     * @return
     */
    List<Long> isFolloweds(Long currentUserId,List<Long> targetUserIds );

    /**
     * 是否存在关注消息 该消息获取一次后就销毁，主要用于私聊中显示关注通知
     *
     * @param userId 当前用户
     * @param targetUserId 目标用户
     * @return true表示有消息
     */
    Boolean hasFollowMsg(Long userId, Long targetUserId);

    /**
     * 点击关注/取消关注
     */
    Boolean follow(Long userId, Long followUserId, Byte type);

    /**
     * 可能感兴趣的人
     */
    List<UserFollow> mayInterested(Long userId, String areaCode);

    /**
     * 关注列表
     */
    PageWarper<UserFollow> followList(UserFollowParam param);

    /**
     * 分页查询用户粉丝列表
     *
     * @param param 查询参数
     * @return 分页结果
     */
    PageWarper<UserFollow> queryFunsByPage(UserFollowParam param);

    /**
     * 虚拟用户批量关注
     *
     * @param userId 目标用户
     * @param num 关注数量
     */
    void virtualFollow(Long userId, Integer num);

}