package com.bxm.localnews.user.attribute;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.bxm.localnews.common.vo.RedisMessageBean;
import com.bxm.localnews.user.vo.UserRedundancyInfo;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 通过redis消息队列接收用户订阅消息
 *
 * @author zhengxiaofeng
 */
public class UserVisitRedisMQReceiver extends BaseService {

    @Autowired
    private UserVisitService userVisitService;

    /**
     * 接收订阅消息，进行访问消息的相关处理
     */
    @SuppressWarnings("unused")
    public void receiveMessage(String message) {
        logger.debug("收到redis订阅信息:[{}]", JSONObject.toJSON(message));
        RedisMessageBean<UserRedundancyInfo> redisMessageBean = JSON
            .parseObject(message, new TypeReference<RedisMessageBean<UserRedundancyInfo>>() {
            });
        UserRedundancyInfo userRedundancyInfo = redisMessageBean.getEventBody();

        //更新用户访客表
        this.userVisitService
            .doTriggerUpdateInfo(userRedundancyInfo.getId(), userRedundancyInfo.getNickname(), userRedundancyInfo.getHeadImg(),
                userRedundancyInfo.getSex());
    }


}
