package com.bxm.localnews.user.attribute.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.user.attribute.DeprecatedService;
import com.bxm.localnews.user.attribute.UserPersonalInfoService;
import com.bxm.localnews.user.attribute.UserTagService;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.UserParam;
import com.bxm.localnews.user.param.UserSyncParam;
import com.bxm.localnews.user.properties.HomePageConfigProperties;
import com.bxm.localnews.user.support.UserSyncService;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserInfoComplete;
import com.bxm.newidea.component.emoji.EmojiCodeParser;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.tools.Validater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageParam;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DeprecatedServiceImpl extends BaseService implements DeprecatedService {

    @Resource
    private UserMapper userMapper;

    @Resource
    private BizLogIntegrationService bizLogIntegrationService;

    @Resource
    private UserSyncService userSyncService;

    @Resource
    private UserService userService;

    @Resource
    private HomePageConfigProperties homePageConfigProperties;

    @Resource
    private UserTagService userTagService;

    @Override
    public Message updateUserInfo(UserParam updateUser, Long userId, MultipartFile file) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        if (null == user) {
            logger.error("用户更新资料时未得到用户:[{}]", JSONObject.toJSONString(updateUser));
            return Message.build(false, "更新失败");
        }
        if (1 != user.getState()) {
            return Message.build(false, "用户尚未登录");
        }
        if (null != updateUser.getNickname()) {
            user.setNickname(EmojiCodeParser.replaceSoftbankEmoji(updateUser.getNickname()));
            //3.0.0 [康文静]取消昵称修改次数限制
//            if (null == user.getIsTempNickName() || user.getIsTempNickName() == 1) {
//                user.setIsTempNickName((byte) 0);
//            } else {
//                return Message.build(false, "该用户修改昵称已达上限");
//            }
        }
        if (null != updateUser.getPhone()) {
            if (!Validater.checkPhone(updateUser.getPhone())) {
                return Message.build(false, "手机号格式有误");
            }
            if (!updateUser.getPhone().equals(user.getPhone()) && userService.checkUserExistByPhone(updateUser.getPhone(), 0)) {
                return Message.build(false, "该手机号已绑定");
            }
            user.setPhone(updateUser.getPhone());
        }
        if (null != updateUser.getSex()) {
            user.setSex(updateUser.getSex());
            bizLogIntegrationService.changeGender(user.getId(), updateUser.getSex(), null);
        }
        if (null != updateUser.getAddress()) {
            user.setAddress(updateUser.getAddress());
        }
        if (null != updateUser.getBirthday()) {
            user.setBirthday(updateUser.getBirthday());
        }
        if (StringUtils.isNotEmpty(updateUser.getHeadImg())) {
            user.setHeadImg(updateUser.getHeadImg());
        }
        if (StringUtils.isNotBlank(updateUser.getPersonalProfile())) {
            //判断是否可以修改个人简介
            if (!homePageConfigProperties.getIsUpdatePersonalProfile()) {
                return Message.build(false, "系统维护中，暂时不支持修改");
            }
            user.setPersonalProfile(updateUser.getPersonalProfile());
        }
        int i = this.userMapper.updateByPrimaryKeySelective(user);
        if (i > 0) {
            UserInfoDTO dto = userService.convertUserToDTO(user);

            logger.info("用户更新后的信息：[{}]", JSON.toJSONString(dto));

            //将变更的用户信息同步到冗余的表设计字段中
            if (null != updateUser.getNickname()
                || null != updateUser.getHeadImg()
                || null != updateUser.getSex()) {
                UserSyncParam userSyncParam = new UserSyncParam();
                BeanUtils.copyProperties(dto, userSyncParam);
                userSyncService.sync(userSyncParam);
            }

            userService.checkCompleteInfo(user);
            this.userService.loadUserToRedis(user.getId());
            return Message.build(true).addParam("user", dto);
        }
        return Message.build(false, "更新失败");
    }

    @Override
    public void updateUserCompleteInfo() {
        //这串代码，写的比较俗，代码流一般的逻辑
        double count = Math.ceil(userMapper.count() / 500.0);

        for (int i = 1; i <= count; i++) {
            PageParam pageParam = new PageParam();
            pageParam.setPageNum(i);
            pageParam.setPageSize(500);
            List<User> userList = userMapper.queryPageByNormal(pageParam);
            List<UserInfoComplete> userInfoCompleteList = new ArrayList<>();
            for (User user : userList) {

                long infoCompleteStatus = SpringContextHolder.getBean(UserPersonalInfoService.class).initUserInfoCompleteStatus(user);
                userInfoCompleteList.add(new UserInfoComplete(user.getId(), infoCompleteStatus));
            }
            MybatisBatchBuilder.create(UserMapper.class, userInfoCompleteList).run(UserMapper::updateUserInfoCompleteStatus);
        }
    }


}
