package com.bxm.localnews.user.auth;

import com.bxm.localnews.auth.enums.AuthCodeEnum;
import com.bxm.localnews.auth.enums.RoleCodeEnum;
import com.bxm.localnews.user.dto.auth.UserAuthResourceDto;
import com.bxm.localnews.user.param.RemoveAuthCodeParam;
import com.bxm.newidea.component.vo.Message;

import java.util.List;

/**
 * 用户授权服务接口
 * @author liujia
 */
public interface UserAuthCodeService {

    /**
     * 获取授权复合编码
     * @param userId 用户ID
     * @return 用户的复合编码
     */
    Long[] getAuthCombineCode(Long userId);

    /**
     * 获取用户拥有的数据资源
     * @param userId 用户ID
     * @return 权限位与数据资源的映射关系
     */
    List<UserAuthResourceDto> getAuthResources(Long userId);

    /**
     * 将用户设定为指定的角色
     * @param userId 用户ID
     * @param role   设定的角色
     * @return 操作结果
     */
    Message addRole(Long userId, RoleCodeEnum role);

    /**
     * 移除用户的角色，同时将移除角色对应权限
     * @param userId 用户ID
     * @param role   权限编码
     * @return 操作结果
     */
    Message removeRole(Long userId, RoleCodeEnum role);

    /**
     * 给用户增加操作权限
     * @param userId   用户ID
     * @param authCode 操作权限
     * @return 操作结果
     */
    Message addAuthCode(Long userId, AuthCodeEnum authCode);

    /**
     * 移除用户的操作权限
     * @param userId   用户ID
     * @param authCode 操作权限
     * @return 操作结果
     */
    Message removeAuthCode(Long userId, AuthCodeEnum authCode);

    /**
     * 给用户增加某一个资源的访问权限
     * @param userId     用户ID
     * @param authCode   操作权限
     * @param resourceId 操作权限对应的数据资源ID
     * @return 操作结果
     */
    Message addResource(Long userId, AuthCodeEnum authCode, String resourceId);

    /**
     * 判断用户是否拥有对应的权限
     * @param userId   用户ID
     * @param authCode 权限编码
     * @return true表示拥有权限
     */
    Boolean hasAuth(Long userId, AuthCodeEnum authCode);

    /**
     * 给用户移除某一个资源的访问权限
     * @param userId     用户ID
     * @param authCode   操作权限
     * @param resourceId 操作权限对应的数据资源ID
     */
    Message removeResource(Long userId, AuthCodeEnum authCode, String resourceId);

    /**
     * 给用户增加多个资源的访问权限
     * @param userId    用户ID
     * @param authCode  操作权限
     * @param resources 多个操作资源对象
     */
    Message addResource(Long userId, AuthCodeEnum authCode, List<String> resources);

    /**
     * 添加移除权限为定时任务
     * @param param
     * @return
     */
    Message addRemoveAuthCodeTask(RemoveAuthCodeParam param);

    /**
     * 移除权限为定时任务
     * @param userId
     * @return
     */
    Message removeAuthCodeTask(Long userId);



}
