/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.invite.bind;

import com.bxm.localnews.user.dto.UserInviteBindDTO;
import com.bxm.localnews.user.enums.InviteBindMethodEnum;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;

/**
 * @author : jieli.xu
 * @date 2020/7/13 20:30
 * 绑定邀请关系管理类
 */
@Component
public class BindInviteManager {
    /**
     * 绑定策略
     */
    private HashMap<InviteBindMethodEnum, AbstractBindInviteStrategy> inviteStrategyHashMap;

    private DefaultBindMethod defaultBindMethod;

    @Autowired
    public BindInviteManager(List<AbstractBindInviteStrategy> listStrategy,
                             DefaultBindMethod defaultBindMethod) {
        inviteStrategyHashMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(listStrategy)) {
            listStrategy.forEach(abstractBindInviteStrategy -> inviteStrategyHashMap.put(abstractBindInviteStrategy.getBindMethod(), abstractBindInviteStrategy));
        }
        this.defaultBindMethod = defaultBindMethod;
    }

    /**
     * 绑定邀请关系
     *
     * @return : 返回绑定结果
     */
    public UserInviteHistoryBean bindInvite(UserInviteBindDTO userInviteBindDTO) {
        return inviteStrategyHashMap.getOrDefault(userInviteBindDTO.getInviteBindMethodEnum(), defaultBindMethod)
                .doBindInvite(userInviteBindDTO);
    }
}
