/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.invite.bind;

import com.bxm.localnews.user.dto.UserInviteBindDTO;
import com.bxm.localnews.user.enums.InviteBindMethodEnum;
import com.bxm.localnews.user.invite.InviteRecordService;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author : jieli.xu
 * @date 2020/7/13 15:13
 * 创建临时用户时绑定关系
 */
@Component
@Slf4j
public class CreateTempUserBindMethod extends AbstractBindInviteStrategy {

    @Autowired
    private InviteRecordService inviteRecordService;

    @Override
    protected Message preInvoke(UserInviteBindDTO userInviteBindDTO) {
        //临时用户创建时必须传入用户信息User
        if(null == userInviteBindDTO.getUser()  || null == userInviteBindDTO.getInviteUserId()){
            return Message.build(false);
        }
        //临时用户，只处理record的记录，不创建邀请关系
        inviteRecordService.addInviteRecord(userInviteBindDTO.getInviteUserId(),userInviteBindDTO.getUserId(),userInviteBindDTO.getUser().getRegisterChannel());
        return Message.build(false);
    }


    @Override
    protected InviteBindMethodEnum getBindMethod() {
        return InviteBindMethodEnum.CREATE_TEMP_USER;
    }


}
