/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.invite.bind;

import com.bxm.localnews.user.domain.InviteRecordMapper;
import com.bxm.localnews.user.dto.UserInviteBindDTO;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.enums.InviteBindMethodEnum;
import com.bxm.localnews.user.enums.InviteRecordStatusEnum;
import com.bxm.localnews.user.param.InviteRecordParam;
import com.bxm.localnews.user.timer.InviteRelationshipTask;
import com.bxm.localnews.user.vo.InviteRecord;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * @author : jieli.xu
 * @date 2020/7/13 19:12
 * 登录以后绑定用户的邀请关系: 主要是用来更新用户的邀请关系状态
 */
@Component
@Slf4j
public class LoginBindMethod extends AbstractBindInviteStrategy {

    @Autowired
    private InviteRecordMapper inviteRecordMapper;

    @Autowired
    private ScheduleService scheduleService;


    @Override
    protected Message preInvoke(UserInviteBindDTO userInviteBindDTO) {
        //登录app判断是否存在邀请记录
        //发生场景：A通过激活码邀请了B，然后B登录了，这个时候需要从潜在徒弟-》真实徒弟
        if (userInviteBindDTO.getAlreadyHas()) {
            userInviteBindDTO.getUserInviteHistoryBean().setBindTime(new Date());
            userInviteBindDTO.getUserInviteHistoryBean().setState(AppConst.USER_STATE.NORMAL);
            userInviteBindDTO.setNeedUpdate(true);
        } else {
            //发生场景：A通过新闻或者其他帖子邀请了B，B登录了，就需要确定最终的关系
            //是否存在邀请记录
            InviteRecordParam inviteRecordParam = new InviteRecordParam();
            inviteRecordParam.setUserId(userInviteBindDTO.getUser().getInviteUserId());
            inviteRecordParam.setInvitedUserId(userInviteBindDTO.getUserId());
            inviteRecordParam.setStatus(InviteRecordStatusEnum.VALID.getStatus());

            List<InviteRecord> inviteRecordList = inviteRecordMapper.queryUserInviteRecord(inviteRecordParam);

            if (!CollectionUtils.isEmpty(inviteRecordList)) {
                userInviteBindDTO.getUserInviteHistoryBean().setState(AppConst.USER_STATE.NORMAL);
                userInviteBindDTO.getUserInviteHistoryBean().setType(userInviteBindDTO.getUser().getRegisterChannel());
                userInviteBindDTO.getUserInviteHistoryBean().setRelationId(userInviteBindDTO.getUser().getRelationId());
                userInviteBindDTO.getUserInviteHistoryBean().setInviteUserId(userInviteBindDTO.getInviteUserId());
                userInviteBindDTO.getUserInviteHistoryBean().setUserId(userInviteBindDTO.getUserId());
            } else {
                return Message.build(false);
            }
        }
        return Message.build(true);
    }

    @Override
    protected Message afterInviteNormal(UserInviteBindDTO userInviteBindDTO) {
        Message message = super.afterInviteNormal(userInviteBindDTO);
        // 删除record的定时过期任务
        scheduleService.remove(InviteRelationshipTask.generateTaskName(userInviteBindDTO.getInviteUserId(), userInviteBindDTO.getUserId()));
        return message;
    }

    @Override
    protected InviteBindMethodEnum getBindMethod() {
        return InviteBindMethodEnum.LOGIN_APP;
    }

}
