/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.invite.bind;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.domain.InviteRecordMapper;
import com.bxm.localnews.user.domain.UserInviteHistoryMapper;
import com.bxm.localnews.user.dto.UserInviteBindDTO;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.enums.InviteBindMethodEnum;
import com.bxm.localnews.user.enums.InviteRecordStatusEnum;
import com.bxm.localnews.user.facade.MerchantFeignService;
import com.bxm.localnews.user.invite.InviteRecordService;
import com.bxm.localnews.user.param.InviteRecordParam;
import com.bxm.localnews.user.vo.InviteRecord;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * @author : jieli.xu
 * @date 2020/7/13 17:52
 * 开通VIP时绑定邀请关系
 */
@Component
@Slf4j
public class WelfareVipBindMethod extends AbstractBindInviteStrategy {
    @Autowired
    private InviteRecordService inviteRecordService;

    @Autowired
    private InviteRecordMapper inviteRecordMapper;

    @Autowired
    private UserInviteHistoryMapper userInviteHistoryMapper;

    @Autowired
    private MerchantFeignService merchantFeignService;

    @Override
    protected Message preInvoke(UserInviteBindDTO userInviteBindDTO) {
        //支付：如果是回调，则插入history
        //不是回调  ： 则插入record
        if (userInviteBindDTO.getIsCallback()) {
            InviteRecordParam inviteRecordParam = new InviteRecordParam();
            inviteRecordParam.setUserId(userInviteBindDTO.getInviteUserId());
            inviteRecordParam.setInvitedUserId(userInviteBindDTO.getUserId());
            inviteRecordParam.setStatus(InviteRecordStatusEnum.VALID.getStatus());
            List<InviteRecord> inviteRecordList = inviteRecordMapper.queryUserInviteRecord(inviteRecordParam);
            if (!CollectionUtils.isEmpty(inviteRecordList)) {
                userInviteBindDTO.getUserInviteHistoryBean().setState(AppConst.USER_STATE.NORMAL);
                userInviteBindDTO.getUserInviteHistoryBean().setType(userInviteBindDTO.getUser().getRegisterChannel());
                userInviteBindDTO.getUserInviteHistoryBean().setRelationId(userInviteBindDTO.getUser().getRelationId());
                userInviteBindDTO.getUserInviteHistoryBean().setInviteUserId(userInviteBindDTO.getInviteUserId());
                userInviteBindDTO.getUserInviteHistoryBean().setUserId(userInviteBindDTO.getUserId());
                userInviteBindDTO.getUserInviteHistoryBean().setActiveVip(AppConst.ENABLE.byteValue());
                userInviteBindDTO.getUserInviteHistoryBean().setRelationTitle(InviteTypeEnum.WELFARE_VIP.getDesc());
                return Message.build(true);
            }
        } else {
            //插入record记录，不做其余操作
            inviteRecordService.addInviteRecord(userInviteBindDTO.getInviteUserId(), userInviteBindDTO.getUserId(), this.getBindMethod().name());
        }
        return Message.build(false);
    }

    @Override
    protected Message afterInviteNormal(UserInviteBindDTO userInviteBindDTO) {
        //更新状态为VIP状态
        userInviteHistoryMapper.updateInvitedUserIdVip(userInviteBindDTO.getUserId());
        //更新商家那边的用户列表为VIP
        merchantFeignService.updateInvitedUserIdVip(userInviteBindDTO.getUserId(), InviteTypeEnum.WELFARE_VIP.name());
        return super.afterInviteNormal(userInviteBindDTO);
    }

    @Override
    protected void beNormalInviteAfter(UserInviteBindDTO userInviteBindDTO) {
        if (null == userInviteBindDTO.getUserInviteHistoryBean().getActiveVip() || Objects.equals(userInviteBindDTO.getUserInviteHistoryBean().getActiveVip(), AppConst.DISALBE.byteValue())) {
            //更新状态为VIP状态
            userInviteHistoryMapper.updateInvitedUserIdVip(userInviteBindDTO.getUserId());
            //更新商家那边的用户列表为VIP
            merchantFeignService.updateInvitedUserIdVip(userInviteBindDTO.getUserId(), InviteTypeEnum.WELFARE_VIP.name());
        }
    }

    @Override
    protected InviteBindMethodEnum getBindMethod() {
        return InviteBindMethodEnum.WELFARE_VIP;
    }
}
