package com.bxm.localnews.user.invite.processor;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.invite.InviteProcessorContext;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Component;

/**
 * 福利VIP卡邀请处理（发生购买的情况下）
 *
 * @author liujia
 * @date 2020/05/11 16:54
 */
@Component
public class WelfareVipInviteTypeProcessor extends AbstractInviteTypeProcessor {
    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.WELFARE_VIP;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        return "的万事通开卡邀请";
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        return "万事通开卡";
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }
}
