package com.bxm.localnews.user.login;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.vo.Message;

/**
 * Created by mars on 2018/2/23.
 */
public interface LoginService {

    /**
     * 用户登录，包括账号密码、验证码、第三方登录
     *
     * @param loginInfo  登录信息
     * @param basicParam 登录来源平台
     */
    Message doLogin(LoginInfo loginInfo, BasicParam basicParam);

    /**
     * 将用户状态更新激活状态
     *
     * @param user       用户信息
     * @param basicParam 基础参数
     * @param equipment  设备信息（可选）
     */
    void updateUserActive(User user, BasicParam basicParam, String equipment);

    /**
     * 注册用户并绑定用户号码
     *
     * @param loginInfo  登录信息
     * @param userId     用户id
     * @param basicParam 基础参数
     */
    Json<LoginMeta> registerAndBindingPhone(LoginInfo loginInfo, Long userId, BasicParam basicParam);

}
