package com.bxm.localnews.user.login;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.exception.UserRepeatCreateException;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.localnews.user.vo.User;

public interface UserRegistrationService {

    /**
     * 用途：app初始静默注册 场景：在用户打开app时，系统会为用户生成一个默认用户，以这个用户来记录用户阅读的新闻
     *
     * @param basicParam 基础参数
     * @param firstOpenType 是否是第一次打开应用，1：首次打开
     */
    Json<LoginMeta> register(LoginInfo loginInfo, BasicParam basicParam, String firstOpenType);

    /**
     * 用途：新增用户以及用户相关的配置（包括用户账户，新手计划，邀请人信息）
     */
    User addUser(LoginInfo loginInfo, BasicParam basicParam, Byte userType) throws UserRepeatCreateException;

}
