package com.bxm.localnews.user.login.adapter;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.param.RegisterParam;
import com.bxm.localnews.user.param.SilentRegisterParam;
import com.bxm.localnews.user.param.WechatBindParam;
import com.bxm.localnews.user.vo.H5RegisterParam;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.math.NumberUtils;

/**
 * 传参适配器
 */
@Slf4j
public class ParamAdapter {

    /**
     * 静默注册时参数适配
     */
    public static LoginInfo transformSilentRegisterToLoginInfo(SilentRegisterParam silentRegisterParam) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setRegisteredaddress(silentRegisterParam.getRegisteredaddress());
        return loginInfo;
    }

    /**
     * 有安卓端，ios端，h5前端三方面的注册，都通用这个类 安卓端：1.手机号注册 2.第三方绑定注册 IOS端：1.手机号注册 2.第三方绑定注册 H5：1.手机号注册 2.第三方绑定注册
     */
    public static LoginInfo transformRegisterToLoginInfo(RegisterParam registerParam, BasicParam basicParam) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setRegisteredaddress(registerParam.getRegisteredaddress());
        loginInfo.setCode(registerParam.getCode());
        loginInfo.setHeadImg(registerParam.getHeadImg());
        loginInfo.setLoginName(registerParam.getLoginName());
        loginInfo.setNickname(registerParam.getNickname());
        loginInfo.setOpenId(registerParam.getOpenId());
        loginInfo.setPassword(registerParam.getPassword());
        loginInfo.setPhone(registerParam.getPhone());
        loginInfo.setInviteCode(registerParam.getInviteCode());
        loginInfo.setType(registerParam.getType());
        loginInfo.setId(registerParam.getId());
        loginInfo.setDeviceToken(registerParam.getDeviceToken());
        return loginInfo;
    }

    /**
     * 微信绑定
     */
    public static LoginInfo transformWechatBindToLoginInfo(WechatBindParam wechatBindParam) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setHeadImg(wechatBindParam.getHeadImg());
        loginInfo.setLoginName(wechatBindParam.getLoginName());
        loginInfo.setNickname(wechatBindParam.getNickname());
        loginInfo.setType(wechatBindParam.getType());
        loginInfo.setId(wechatBindParam.getId());
        return loginInfo;
    }


    public static LoginInfo transformLoginParamToLoginInfo(LoginParam loginParam, BasicParam basicParam) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setId(loginParam.getId());
        loginInfo.setCode(loginParam.getCode());
        loginInfo.setHeadImg(loginParam.getHeadImg());
        loginInfo.setLoginName(loginParam.getLoginName());
        loginInfo.setNickname(loginParam.getNickname());
        loginInfo.setPassword(loginParam.getPassword());
        loginInfo.setPhone(loginParam.getPhone());
        loginInfo.setInviteCode(loginParam.getInviteCode());
        loginInfo.setType(loginParam.getType());
        loginInfo.setResetPwd(loginParam.getResetPwd());
        loginInfo.setOpenId(loginParam.getOpenId());
        loginInfo.setUnionId(loginParam.getUnionId());
        loginInfo.setPhonemodel(loginParam.getPhonemodel());
        loginInfo.setCurVer(basicParam.getCurVer());
        loginInfo.setVersion(basicParam.getVersion());
        loginInfo.setOperatingSystem(loginParam.getOperatingSystem());
        loginInfo.setSex(changeSex(loginParam));
        return loginInfo;
    }

    private static Byte changeSex(LoginParam loginParam) {
        if (loginParam.getSex() == null) {
            return (byte) 0;
        }

        if (NumberUtils.isDigits(loginParam.getSex())) {
            return Byte.valueOf(loginParam.getSex());
        }

        log.warn("请求性别参数异常，进行修正处理：{}", JSON.toJSONString(loginParam));

        switch (loginParam.getSex()) {
            case "男":
                return (byte) 1;
            case "女":
                return (byte) 2;
            default:
                return (byte) 0;
        }
    }

    public static LoginInfo transformH5Register(H5RegisterParam registerParam) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setCode(registerParam.getCode());
        loginInfo.setLoginName(registerParam.getLoginName());
        loginInfo.setPassword(registerParam.getPassword());
        loginInfo.setPhone(registerParam.getPhone());
        loginInfo.setInviteCode(registerParam.getInviteCode());
        loginInfo.setType(registerParam.getType());
        loginInfo.setId(registerParam.getId());
        return loginInfo;
    }

}
