/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.login.protocal;

import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.ProtocalInfoStrategyDTO;
import com.bxm.localnews.user.dto.UserInviteBindDTO;
import com.bxm.localnews.user.enums.InviteBindMethodEnum;
import com.bxm.localnews.user.enums.ProtocalTypeEnum;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.invite.bind.BindInviteManager;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;
import java.util.Objects;

/**
 * @author : jieli.xu
 * @date 2020/7/14 10:22
 * 邀请粘贴板的内容处理
 */
@Component
@Slf4j
public class InviteProtocalMethod extends AbstractProtocalStrategy {

    @Autowired
    private BizLogIntegrationService bizLogIntegrationService;
    @Resource
    private UserMapper userMapper;
    @Autowired
    private BindInviteManager bindInviteManager;
    @Override
    public Message doInvokeProtocal(ProtocalInfoStrategyDTO protocalParam) {
        Map<String,String> params = protocalParam.getParams();
        Long shareId = Long.parseLong(params.get("shareId"));
        if(Objects.equals(protocalParam.getUserClipboardParam().getUserId(),shareId)){
            return Message.build(false);
        }
        //上报数据埋点
        PointReportParam reportParam = PointReportParam.build(protocalParam.getUserClipboardParam())
                .e("3034")
                .ev("120." + String.valueOf(shareId))
                .put("uid", String.valueOf(protocalParam.getUserClipboardParam().getUserId()));
        reportParam.dtype(protocalParam.getUserClipboardParam().getPlatform()+"");
        bizLogIntegrationService.point(reportParam);
        //业务逻辑
        User user = userMapper.selectByUserId(protocalParam.getUserClipboardParam().getUserId());
        if(null == user || null != user.getInviteUserId()){
            return null;
        }
        //绑定邀请关系
        UserInviteBindDTO userInviteBindDTO = new UserInviteBindDTO();
        userInviteBindDTO.setInviteBindMethodEnum(InviteBindMethodEnum.POSTERS_SHARE);
        userInviteBindDTO.setUserId(protocalParam.getUserClipboardParam().getUserId());
        userInviteBindDTO.setInviteUserId(shareId);
        UserInviteHistoryBean bean = bindInviteManager.bindInvite(userInviteBindDTO);
        return Message.build(null == bean);
    }

    @Override
    protected Integer getType() {
        return ProtocalTypeEnum.INVITE.getType();
    }
}
