package com.bxm.localnews.user.support;

import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * 与业务无关的扩展无法
 */
@Component
@Slf4j
public class ExtendedService extends BaseService {

    @Resource
    private AliyunOSSService aliyunOSSService;

    @Resource
    private UserProperties userProperties;

    /**
     * 将用户头像上传到阿里云，如果是微信头像，尝试获取高清头像
     *
     * @param headImg 头像图片地址
     * @param userId  用户ID
     * @return 上传后的头像地址
     */
    public String uploadHeadImg(String headImg, Long userId) {
        if (null == headImg) {
            return null;
        }

        try {
            //尝试获取高清图片地址,0代表高清头像，132代表132像素
            if (StringUtils.endsWith(headImg, "132")) {
                headImg = headImg.substring(0, headImg.length() - 3) + "0";
            } else if (StringUtils.endsWith(headImg, "96")
                    || StringUtils.endsWith(headImg, "64")
                    || StringUtils.endsWith(headImg, "46")) {
                headImg = headImg.substring(0, headImg.length() - 2) + "0";
            }

            URL url = new URL(headImg);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();

            // 设置连接超时时间
            conn.setConnectTimeout(3000);
            InputStream inputStream = null;

            // 正常响应时获取输入流, 在这里也就是图片对应的字节流
            if (conn.getResponseCode() == HttpStatus.OK.value()) {
                inputStream = conn.getInputStream();
                log.debug("根据url获得图片的流状态：{}", inputStream.available());
            }
            //不知道用户id---随机生成一个id来存到对应图片路径中
            if (userId == null) {
                userId = nextId();
            }

            int hashCode = (int) (userId % 100);
            String path = "avatar/" + hashCode + "/" + userId + ".jpeg";
            return aliyunOSSService.upload(inputStream, path) + "?x-oss-process=style/head";
        } catch (IOException e) {
            log.error("微信授权上传头像出错，使用默认头像，用户id:[{}],用户头像:[{}],错误:[{}]", userId, headImg, e.getMessage());
            headImg = userProperties.getDefaultHeadImgUrl();
        }

        return headImg;
    }
}
