package com.bxm.localnews.user.support;

import com.bxm.localnews.user.dto.h5.ClientVersionDto;
import com.bxm.localnews.user.vo.UserEquipment;
import com.bxm.newidea.component.vo.Message;

/**
 * @author zhaoyadong 2019/4/16 14:50
 * @desc
 */
public interface UserEquipmentService {

    /**
     * 查询设备号对应的信息
     */
    UserEquipment selectByEquipment(String equipment);

    /**
     * 添加设备号信息
     */
    Message addUserEquipment(UserEquipment userEquipment);

    /**
     * 是否存在对应活动类型的设备号信息
     */
    Message checkExistEquipment(String equipment, String activityType);

    /**
     * 获取用户的客户端信息
     *
     * @param userId 用户ID
     * @param curVer 客户端当前版本
     * @return 客户端版本信息
     */
    ClientVersionDto queryClientVersion(Long userId, String curVer);
}
