package com.bxm.localnews.user.support;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.UserBaseInfoDTO;
import com.bxm.localnews.user.param.UserLocationParam;

/**
 * 用户相关内部接口，不对外服务暴露
 */
public interface UserInternalService {

    /**
     * 用户进行定位，并存在历史定位表中，需要事务
     */
    LocationDTO doPostingLocation(String code, Long userId, BasicParam basicParam, String ip);

    /**
     * 用途：用户在更换地区后的异步操作 1.更新用户的用户位置信息 2.日志埋点 3.更新用户再redis的对象 4.清空用户首页缓存 5.新增用户定位历史表
     */
    void afterPostingLocation(LocationDTO locationDTO, Long userId, BasicParam basicParam, String ip);

    /**
     * 获取用户头像文件流 由于客户端请求微信头像跨域，所以要在这里将头像转为文件流给客户端
     */
    String getUserHeaderImg(Long userId);

    /**
     * 用途：获取个人中心页面用户的信息【我的】
     */
    UserBaseInfoDTO getUserPersonalCenterInfo(Long userId, int platform);

    /**
     * 统计注册用户
     */
    int countRegUser(String startTime, String endTime);

    /**
     * 上报用户位置信息与用户登录信息-用户的经纬度以及用户登录app的活跃信息
     *
     * @param userLocationParam 用户位置信息参数
     */
    Boolean postUserPositionAndLoginInfo(UserLocationParam userLocationParam);

}
