package com.bxm.localnews.user.support;

/**
 * 地区用户统计服务
 *
 * @author liujia
 * @date 2020-08-06 20:22
 **/
public interface UserRankService {

    /**
     * 获取地区的总人数
     *
     * @param areaCode 地区编码
     * @return 地区总人数，如果参数为空则返回0
     */
    Long getTotal(String areaCode);

    /**
     * 获取某一个区域的VIP总人数
     *
     * @param areaCode 地区编码
     * @return 地区VIP总人数，如果参数为空则返回0
     */
    Long getVipTotal(String areaCode);

    /**
     * 获取用户在地区的省钱排行榜排名
     *
     * @param userId   用户ID
     * @param areaCode 用户所在地区
     * @return 地区省钱排行榜中的排名，如果返回0说明用户无排行
     */
    Long getSaveCashRank(Long userId, String areaCode);

    /**
     * 获取用户的收徒排行榜
     *
     * @param userId   用户ID
     * @param areaCode 用户所在区域
     * @return 收徒排行榜的排名，如果返回0则说明无排行
     */
    Long getInviteNumRank(Long userId, String areaCode);

    /**
     * 当用户定位信息变更时，移动用户的排行榜
     *
     * @param userId         用户ID
     * @param sourceAreaCode 原地区编码
     * @param targetAreaCode 迁移后的地区编码
     */
    void moveRank(Long userId, String sourceAreaCode, String targetAreaCode);

    /**
     * 用户的省钱数据变更时重新加载用户的省钱排行到缓存
     *
     * @param userId 用户ID
     */
    void reloadUserSaveCashRank(Long userId);

    /**
     * 初始化缓存信息
     * 更新各个地区的总人数信息
     * 更新各个地区的VIP总人数信息
     */
    void execInitCache();

    /**
     * 刷新省钱排行榜
     */
    void refreshSaveCashRank();

    /**
     * 刷新收徒排行榜
     */
    void refreshInviteRank();
}
