package com.bxm.localnews.user.support.impl;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.ChannelMapper;
import com.bxm.localnews.user.dto.ChannelDTO;
import com.bxm.localnews.user.properties.BizConfigProperties;
import com.bxm.localnews.user.support.ChannelService;
import com.bxm.localnews.user.vo.Channel;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageHelper;
import java.util.List;
import java.util.Map;

import lombok.AllArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import static org.apache.commons.lang3.StringUtils.join;

/**
 * Created by Administrator on 2017/12/23.
 */

@Service
@RefreshScope
@AllArgsConstructor
public class ChannelServiceImpl implements ChannelService {

    private final static Logger logger = LoggerFactory.getLogger(ChannelServiceImpl.class);

    private ChannelMapper channelMapper;

    private BizConfigProperties bizConfigProperties;

    private RedisStringAdapter redisStringAdapter;

    private final DomainIntegrationService domainIntegrationService;

    @Override
    public List<ChannelDTO> listChannel(Map<String, Object> searchMap, int current, int pageSize) {
        PageHelper.startPage(current, pageSize);
        List<ChannelDTO> list = this.channelMapper.selectChannelList(searchMap);
        String channelUrl = join(domainIntegrationService.getInnerH5BaseUrl(), bizConfigProperties.getChannelPath());

        for (ChannelDTO channelDTO : list) {
            channelDTO.setGeneralizeUrl(channelUrl + channelDTO.getCode());
        }

        return list;
    }

    @Override
    public Channel getChannelByCode(String code) {
        Channel channel = new Channel();
        List<Channel> channelList = getChannelList();
        for (Channel ch : channelList) {
            if (ch.getCode().equals(code)) {
                channel = ch;
                break;
            }
        }

        return channel;
    }

    @Override
    public Long getChannelId(String chnl) {
        //判断用户渠道
        return getChannelByCode(chnl).getId();
    }

    @Override
    public String getChannelCodeById(Long channelId) {
        Channel channel = new Channel();
        List<Channel> channelList = getChannelList();
        for (Channel ch : channelList) {
            if (ch.getId().equals(channelId)) {
                channel = ch;
                break;
            }
        }
        return channel.getCode();
    }

    /**
     * 获取所有的渠道列表
     */
    private List<Channel> getChannelList() {
        TypeReference<List<Channel>> typeReference = new TypeReference<List<Channel>>() {
        };
        List<Channel> channelList = this.redisStringAdapter.get(this.getChannelListKey(), typeReference);
        if (CollectionUtils.isEmpty(channelList)) {
            channelList = this.channelMapper.getAllChannel();
            this.redisStringAdapter.set(this.getChannelListKey(), channelList);
        }

        return channelList;
    }

    /**
     * 获取渠道版本列表的key
     */
    private KeyGenerator getChannelListKey() {
        return RedisConfig.BASE_CHANNEL.copy().appendKey("list");
    }

}
