package com.bxm.localnews.user.support.impl;

import com.bxm.localnews.user.event.RedundancyActionEvent;
import com.bxm.localnews.user.event.UserActionEvent;
import com.bxm.localnews.user.integration.IMIntegrationService;
import com.bxm.localnews.user.param.UserSyncParam;
import com.bxm.localnews.user.support.UserSyncService;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.eventbus.EventBus;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class UserSyncServiceImpl extends BaseService implements UserSyncService {

    @Resource
    private IMIntegrationService imIntegrationService;

    @Resource
    private EventBus userActionEventBus;

    @Override
    public void sync(UserSyncParam user) {
        UserActionEvent userActionEvent = RedundancyActionEvent.of().setHeadImg(user.getHeadImg())
                .setNickName(user.getNickname())
                .setUserId(user.getId());
        // 用户冗余信息同步
        userActionEventBus.post(userActionEvent);

        //更新即时通讯的用户信息
        imIntegrationService.syncUser(user.getId());
    }
}
