package com.bxm.localnews.user.support.impl;

import com.bxm.localnews.user.constant.CommonConstants;
import com.bxm.localnews.user.domain.VirtualUserMapper;
import com.bxm.localnews.user.dto.UserEntertranningDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.support.VirtualUserService;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@Log4j2
public class VirtualUserServiceImpl implements VirtualUserService {

    private final VirtualUserMapper userMapper;

    @Autowired
    public VirtualUserServiceImpl(VirtualUserMapper userMapper) {
        this.userMapper = userMapper;
    }

    @Override
    public List<UserInfoDTO> listVirtualUser(Integer num) {
        return userMapper.getVirtualUserList(num);
    }

    @Override
    public List<UserInfoDTO> listVirtualUserNew(Integer num, List<Integer> types, String areaCode) {
        if (StringUtils.isBlank(areaCode)) {
            areaCode = "";
        }

        return userMapper.getVirtualUserListNew(num, types, areaCode);
    }

    @Override
    public Byte getVirtualUserType(Long userId) {
        Byte type = userMapper.getVirtualUserType(userId);
        if (null != type) {
            return type;
        }
        return 0;
    }

    @Override
    public List<UserEntertranningDTO> listEntertaining(Integer num) {
        if (num > CommonConstants.ENTERTRANING_NUM_LIMIT) {
            num = CommonConstants.ENTERTRANING_NUM_LIMIT;
        }
        List<UserInfoDTO> list = this.listVirtualUser(num);
        List<UserEntertranningDTO> listResult = new ArrayList<>();
        for (UserInfoDTO uid : list) {
            UserEntertranningDTO entity = new UserEntertranningDTO();
            entity.setHeadImg(uid.getHeadImg());
            entity.setNickname(uid.getNickname());
            listResult.add(entity);
        }
        return listResult;
    }
}
