package com.bxm.localnews.user.timer;

import com.bxm.localnews.user.support.UserRankService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 刷新省钱、收徒排行的任务
 * 用于初始化各个地区的省钱排行榜
 *
 * @author liujia
 * @date 2020-08-07 11:42
 **/
@Component
public class RefreshRankTask extends AbstractCronTask<String> {

    @Resource
    private UserRankService userRankService;

    @Override
    protected ReturnT<String> service(String param) {
        userRankService.refreshSaveCashRank();
        userRankService.refreshInviteRank();
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String cron() {
        return "0 0/30 * * * ?";
    }
}
