package com.bxm.localnews.user.timer;

import com.bxm.localnews.user.support.UserRankService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 定时更新地区统计信息
 *
 * @author liujia
 * @date 2020-08-07 11:42
 **/
@Component
public class UserAreaCountTask extends AbstractCronTask<String> {

    @Resource
    private UserRankService userRankService;

    @Override
    protected ReturnT<String> service(String param) {
        userRankService.execInitCache();
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String cron() {
        return "0 0/30 * * * ?";
    }
}
