/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.timer;

import com.bxm.localnews.user.domain.UserVipHistoryMapper;
import com.bxm.localnews.user.enums.ActivationVipStatusEnum;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.localnews.user.vo.UserVip;
import com.bxm.localnews.user.vo.UserVipHistory;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 用户vip过期定时任务更新
 *
 * @author : jieli.xu
 * @date 2020/5/14 16:57
 */
@Component
@Slf4j
public class UserVipTimeoutTask extends AbstractCronTask<String> {
    @Autowired
    private UserVipService userVipService;

    @Autowired
    private UserVipHistoryMapper userVipHistoryMapper;

    @Autowired
    private SequenceCreater sequenceCreater;

    @Override
    protected ReturnT<String> service(String callbackParam) {
        List<UserVip> timeoutVipInfo = userVipService.getExpiredVipList(ActivationVipStatusEnum.USEFUL.getStatus(), new Date());

        if (timeoutVipInfo.size() > 0) {
            List<Long> userIds = timeoutVipInfo.stream().map(UserVip::getUserId).collect(Collectors.toList());
            userVipService.updateBatchStatusByUid(ActivationVipStatusEnum.TIMEOUT.getStatus(), userIds);

            //删除缓存信息
            for (UserVip userVip : timeoutVipInfo) {
                userVipService.removeCache(userVip.getUserId());

                //记录VIP到期信息
                UserVipHistory vipHistory = new UserVipHistory();
                vipHistory.setId(sequenceCreater.nextLongId());
                vipHistory.setOperation("VIP到期");
                vipHistory.setVipId(userVip.getId());
                vipHistory.setUserId(userVip.getUserId());

                userVipHistoryMapper.insertSelective(vipHistory);
            }
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "USER_VIP_TIME_OUT_TASK";
    }

    @Override
    public String cron() {
        return "5 0 0 * * ?";
    }

    @Override
    public String description() {
        return "每天更新过期的VIP用户";
    }
}
