/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.vip;

import com.bxm.localnews.user.dto.vip.VipActivationResultDTO;
import com.bxm.localnews.user.model.VipCardInfoDTO;
import com.bxm.localnews.user.model.VipInfoDetailDTO;
import com.bxm.localnews.user.model.param.VipQueryParam;
import com.bxm.localnews.user.param.ActivationUserVipParam;
import com.bxm.localnews.user.param.VipActivationCodeParam;
import com.bxm.localnews.user.param.VipPaymentCallbackParam;
import com.bxm.localnews.user.vo.UserVip;
import com.bxm.newidea.component.vo.Message;

import java.util.Date;
import java.util.List;

/**
 * V3.2.0 新增的福利会员卡相关信息
 *
 * @author : jieli.xu
 * @date 2020/5/14 16:57
 */
public interface UserVipService {
    /**
     * 获取配置项列表
     *
     * @return
     */
    List<VipCardInfoDTO> getVipCardList();

    /**
     * id获取单个配置信息
     *
     * @param id Vip卡的id
     * @return
     */
    VipCardInfoDTO getVipCardInfo(String id);

    /**
     * 激活码激活VIP
     *
     * @param : type - 0站内使用 1-站外使用
     * @return
     */
    VipActivationResultDTO execActivationVipByCode(VipActivationCodeParam vipActivationCodeParam, Integer type);

    /**
     * vip 卡充值激活vip
     *
     * @param param 支付完成后的回调参数
     * @return 激活结果
     */
    Boolean execActivationVipByPay(VipPaymentCallbackParam param);

    /**
     * 用户首次成为VIP
     * 1.设置用户的VIP卡号
     * 2.给用户设置对应的激活码
     * 3.VIP操作历史记录存储
     *
     * @param param VIP激活参数
     * @return VIP信息创建结果
     */
    Message createVip(ActivationUserVipParam param);

    /**
     * 执行VIP续约操作
     *
     * @param param VIP激活参数
     * @return 续约结果
     */
    Message execRenew(ActivationUserVipParam param);

    /**
     * 用户id获取用户会员信息
     * b不会返回空，会返回一个状态是未激活的
     *
     * @param userId 用户id
     * @return
     */
    UserVip getUserVipByUid(Long userId);

    /**
     * 判断用户是否是VIP
     *
     * @param userId ： 用户id
     * @return true:是：false ：否
     */
    Boolean isVip(Long userId);

    /**
     * 查询过期日期相等，并且会员卡是正常的会员信息
     *
     * @param status      会员卡状态
     * @param expiredDate 过期时间
     * @return
     */
    List<UserVip> getExpiredVipList(Integer status, Date expiredDate);

    /**
     * 批量更新会员信息状态
     *
     * @param status  更新的状态
     * @param userIds 用户的id集合
     * @return
     */
    int updateBatchStatusByUid(Integer status, List<Long> userIds);

    /**
     * 移除用户的VIP缓存信息
     *
     * @param userId 用户ID
     */
    void removeCache(Long userId);

    /**
     * 获取vip信息
     *
     * @param param VIP查询参数
     * @return vip详细信息
     */
    VipInfoDetailDTO getVipDetail(VipQueryParam param);

    /**
     * 购买商品时，勾选了vip，所以这里是付费激活VIP
     * @param param ： 参数，相关完善参数在实现方法里面补充，调用那边只传入orderId和userId，userName
     * @return ： 激活结果
     */
    Boolean activeVipPay(ActivationUserVipParam param);
}
