package com.bxm.localnews.user.vip;

import java.util.List;

/**
 * VIP卡号创建处理服务接口
 *
 * @author liujia
 * @date 2020/6/2 10:21
 **/
public interface VipCardService {

    /**
     * 获取地区对应的下一个VIP卡号
     *
     * @param areaCode 地区编码，作为卡号的组成规则的一部分
     * @return VIP卡号
     */
    String nextCard(String areaCode);

    /**
     * 批量获取一定数量的VIP卡号，用于保证连号
     *
     * @param areaCode 地区编码
     * @param limit    获取数量
     * @return 连号的VIP卡信息
     */
    List<String> nextCard(String areaCode, int limit);
}
