/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.vip.activation;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.constant.VipCardTypeEnum;
import com.bxm.localnews.user.account.impl.AccountHandlerProxy;
import com.bxm.localnews.user.constant.VipActivationChannel;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.enums.ActivationVipEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.integration.PushMsgIntegrationService;
import com.bxm.localnews.user.model.VipCardInfoDTO;
import com.bxm.localnews.user.param.AccountActionParam;
import com.bxm.localnews.user.param.ActivationUserVipParam;
import com.bxm.localnews.user.properties.UserVipProperties;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDate;

/**
 * 通过购买开通的VIP
 *
 * @author : jieli.xu
 * @date 2020/5/14 16:57
 */
@Component
@Slf4j
public class PayActivationStrategy extends AbstractActivationVipStrategy {

    @Autowired
    UserVipProperties userVipProperties;

    @Autowired
    private PushMsgIntegrationService pushMsgIntegrationService;

    @Autowired
    private AccountHandlerProxy accountHandlerProxy;

    @Override
    protected Message preCheck(ActivationUserVipParam param) {
        if (null == param.getUserId()) {
            throw new RuntimeException("用户id不能为空");
        }
        if (null == param.getOrderId()) {
            throw new RuntimeException("订单id不能为空");
        }
        if (null == param.getPlatformEnum()) {
            param.setPlatformEnum(PlatformEnum.ANDROID.getCode());
        }

        //内部调用，就不用查询订单了
        VipCardInfoDTO vipCardInfoDTO = getUserVipService().getVipCardInfo(param.getVipCardId());

        //卡类型判断
        if (null == vipCardInfoDTO) {
            log.error("购买的VIP卡类型不存在，请求参数：{}", param);
            return Message.build(false, "VIP卡类型不存在");
        }

        if (StringUtils.isBlank(param.getChannel())) {
            param.setChannel(VipActivationChannel.PAYMENT);
        }

        return Message.build();
    }

    @Override
    protected void afterSuccess(ActivationUserVipParam param) {
        if (null != param.getMasterId()) {
            log.info("用户【{}】付费购买vip成功，给师傅【{}】发送推送和金额奖励",
                    param.getUserId(),
                    param.getMasterId());
            // 如果是购买VIP，给上级发放现金奖励
            AccountActionParam accountActionParam = AccountActionParam.cashBuilder()
                    .amount(userVipProperties.getMasterReward())
                    .userId(param.getMasterId())
                    .remark("邀请好友开通万事通VIP奖励")
                    .action(AccountActionEnum.ADD_DRAWABLE_CASH)
                    .cashFlowType(CashFlowTypeEnum.INVITE_VIP)
                    .build();
            accountHandlerProxy.handle(accountActionParam);

            //发送消息推送
            pushMsgIntegrationService.pushMasterReceiveAward(param.getMasterId(),
                    param.getUserName(),
                    userVipProperties.getMasterReward());
        }
    }

    @Override
    InviteTypeEnum getInviteType() {
        return InviteTypeEnum.WELFARE_VIP;
    }

    @Override
    public ActivationVipEnum getType() {
        return ActivationVipEnum.PAY;
    }

    @Override
    int getDuration(ActivationUserVipParam param) {
        VipCardInfoDTO vipCardInfo = getUserVipService().getVipCardInfo(param.getVipCardId());

        VipCardTypeEnum cardType = VipCardTypeEnum.valueOf(vipCardInfo.getType());
        LocalDate current = LocalDate.now();
        LocalDate nextLocalData;

        switch (cardType) {
            case DAY:
                nextLocalData = LocalDate.now().plusDays(1);
                break;
            case WEEK:
                nextLocalData = LocalDate.now().plusWeeks(1);
                break;
            case MONTH:
                nextLocalData = LocalDate.now().plusMonths(1);
                break;
            default:
                nextLocalData = LocalDate.now().plusYears(1);
                break;
        }

        return (int) (nextLocalData.toEpochDay() - current.toEpochDay());
    }
}
