package com.bxm.localnews.user.vip.code;

import com.bxm.localnews.user.enums.ActivationVipEnum;
import com.bxm.localnews.user.enums.ActiveCodeTypeEnum;
import com.bxm.localnews.user.vo.vip.UserActiveCodeBean;
import lombok.Builder;
import lombok.Data;

/**
 * 激活码处理上下文对象
 *
 * @author liujia
 * @date 2020/6/3 10:28
 **/
@Data
@Builder
public class ActiveCodeProcessContext {

    /**
     * 填写激活码的用户ID
     */
    private Long userId;

    /**
     * 提供的激活码（可选，如果是购买VIP，则此字段为空）
     */
    private String code;

    /**
     * 激活VIP的类型
     */
    private ActivationVipEnum activationVipType;

    /**
     * 激活码类型
     */
    private ActiveCodeTypeEnum activeCodeType;

    /**
     * 根据激活码获取的对应激活码原始信息
     */
    private UserActiveCodeBean sourceCodeInfo;

    /**
     * 本次处理产生的新的激活码
     */
    private String newActiveCode;

    /**
     * 处理流程中产生的卡号
     */
    private String newCardNo;

    /**
     * 用户当前定位地区
     */
    private String userAreaCode;
}
