package com.bxm.localnews.user.vip.code.impl;

import com.bxm.localnews.user.domain.vip.UserActiveCodeMapper;
import com.bxm.localnews.user.domain.vip.UserActiveRelationMapper;
import com.bxm.localnews.user.enums.ActiveCodeTypeEnum;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.param.ActivationUserVipParam;
import com.bxm.localnews.user.properties.UserVipProperties;
import com.bxm.localnews.user.vip.ActiveCodeService;
import com.bxm.localnews.user.vip.VipCardService;
import com.bxm.localnews.user.vip.code.ActiveCodeProcessContext;
import com.bxm.localnews.user.vip.code.IActiveCodeProcessStrategy;
import com.bxm.localnews.user.vo.vip.UserActiveCodeBean;
import com.bxm.localnews.user.vo.vip.UserActiveRelationBean;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 抽象的激活码处理逻辑策略
 *
 * @author liujia
 * @date 2020/6/3 14:48
 **/
public abstract class AbstractCodeProcessStrategy implements IActiveCodeProcessStrategy {

    @Autowired
    UserActiveCodeMapper userActiveCodeMapper;

    @Autowired
    UserActiveRelationMapper userActiveRelationMapper;

    @Autowired
    VipCardService vipCardService;

    @Autowired
    SequenceCreater sequenceCreater;

    @Autowired
    UserVipProperties userVipProperties;

    ActiveCodeService activeCodeService;

    ActiveCodeService getActiveCodeService() {
        if (activeCodeService == null) {
            activeCodeService = SpringContextHolder.getBean(ActiveCodeService.class);
        }
        return activeCodeService;
    }

    /**
     * 创建一个新的激活码信息
     *
     * @param context        激活码处理上下文
     * @param activeCodeType 创建的激活码类型
     */
    void saveActiveCodeRecord(ActiveCodeProcessContext context, ActiveCodeTypeEnum activeCodeType) {
        saveActiveCodeRecord(context, activeCodeType, userVipProperties.getDefaultCodeNum());
    }

    /**
     * 创建一个新的激活码信息
     *
     * @param context        激活码处理上下文
     * @param activeCodeType 创建的激活码类型
     */
    void saveActiveCodeRecord(ActiveCodeProcessContext context, ActiveCodeTypeEnum activeCodeType, Integer maxTimes) {
        UserActiveCodeBean record = new UserActiveCodeBean();
        record.setId(sequenceCreater.nextLongId());
        record.setMaxTimes(maxTimes);
        record.setActiveTimes(0);
        record.setStatus(AppConst.ENABLE);
        record.setAreaCode(context.getUserAreaCode());
        record.setCardNo(context.getNewCardNo());
        record.setActiveCode(context.getNewActiveCode());
        record.setCreateTime(new Date());
        record.setUserId(context.getUserId());
        record.setCardType(activeCodeType.getCode());

        userActiveCodeMapper.insert(record);
    }

    /**
     * 保存激活码的使用关联关系
     * 激活码的使用次数扣除已经在VIP的前置流程中做了处理
     * {@link com.bxm.localnews.user.vip.activation.CodeActivationStrategy#preCheck(ActivationUserVipParam)}
     *
     * @param context 激活码处理上下文
     */
    void saveActiveRelation(ActiveCodeProcessContext context) {
        UserActiveRelationBean record = new UserActiveRelationBean();
        record.setId(sequenceCreater.nextLongId());
        record.setActiveCode(context.getCode());
        record.setActiveUserId(context.getUserId());
        record.setActivieTime(new Date());
        record.setSourceUserId(context.getSourceCodeInfo().getUserId());

        userActiveRelationMapper.insert(record);
    }
}
