package com.bxm.localnews.user.vip.code.impl;

import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.vip.ActiveCodeDTO;
import com.bxm.localnews.user.enums.ActiveCodeTypeEnum;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.vip.code.ActiveCodeProcessContext;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 支付产生的激活码处理逻辑
 *
 * @author liujia
 * @date 2020/6/3 14:47
 **/
@Component
public class PaymentCodeStrategy extends AbstractCodeProcessStrategy {

    @Autowired
    private UserService userService;

    @Override
    public ActiveCodeDTO process(ActiveCodeProcessContext context) {
        String cardNo = null;
        String activeCode = getActiveCodeService().nextCode();

        UserInfoDTO user = userService.getUserCache(context.getUserId());

        // 如果用户信息中包含地区，则创建卡号,否则将交由获取VIP信息时的逻辑进行卡号修正
        if (StringUtils.isNotBlank(user.getLocationCode())) {
            cardNo = vipCardService.nextCard(user.getLocationCode());
            context.setUserAreaCode(user.getLocationCode());
        }

        // 将激活码信息落库
        context.setNewCardNo(cardNo);
        context.setNewActiveCode(activeCode);
        saveActiveCodeRecord(context, ActiveCodeTypeEnum.PAYMENT);

        return ActiveCodeDTO.builder()
                .activeCode(activeCode)
                .cardNo(cardNo)
                .build();
    }

    @Override
    public ActiveCodeTypeEnum match() {
        return ActiveCodeTypeEnum.PAYMENT;
    }
}
