/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.localnews.user.account.CashFlowService;
import com.bxm.localnews.user.account.ProcessorService;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.account.UserWithdrawService;
import com.bxm.localnews.user.account.impl.AccountHandlerProxy;
import com.bxm.localnews.user.account.impl.callback.IAccountActionCallback;
import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserAccountMapper;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.UserAccountDTO;
import com.bxm.localnews.user.dto.UserAccountDayCashDTO;
import com.bxm.localnews.user.dto.UserCashGoldDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserWithdrawDTO;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.enums.AwardTypeEnum;
import com.bxm.localnews.user.enums.CashEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.enums.ExtraInviteStateEnum;
import com.bxm.localnews.user.enums.GoldEnum;
import com.bxm.localnews.user.enums.GoldFlowTypeEnum;
import com.bxm.localnews.user.enums.InviteRecordStateEnum;
import com.bxm.localnews.user.enums.WithdrawEnum;
import com.bxm.localnews.user.exception.UserAccountException;
import com.bxm.localnews.user.integration.LocationIntegrationService;
import com.bxm.localnews.user.integration.MessageUserIntegrationService;
import com.bxm.localnews.user.integration.PushMsgIntegrationService;
import com.bxm.localnews.user.integration.WithdrawIntegrationService;
import com.bxm.localnews.user.invite.InviteRecordService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.AccountActionParam;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.param.AccountGoldParam;
import com.bxm.localnews.user.param.TransformParam;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.localnews.user.vo.CashFlow;
import com.bxm.localnews.user.vo.GoldFlow;
import com.bxm.localnews.user.vo.InviteRecord;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.localnews.user.vo.UserCashInfoVo;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserAccountServiceImpl
extends BaseService
implements UserAccountService {
    private final UserAccountMapper userAccountMapper;
    private final DistributedLock distributedLock;
    private final CashFlowService cashFlowService;
    private final UserWithdrawService userWithdrawService;
    private final UserService userService;
    private final InviteRecordService inviteRecordService;
    private final MessageSender messageSender;
    private final RedisStringAdapter redisStringAdapter;
    private final PushMsgIntegrationService pushMsgIntegrationService;
    private final MessageUserIntegrationService messageUserIntegrationService;
    private final UserProperties userProperties;
    private final WithdrawIntegrationService withdrawIntegrationService;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final RedisListAdapter redisListAdapter;
    private final RedisSetAdapter redisSetAdapter;
    private final LocationIntegrationService locationIntegrationService;
    private final AccountHandlerProxy accountHandlerProxy;

    @Override
    public BigDecimal getUserTotalCash(Long userId) {
        return this.getUserAccountDetail(userId).getTotalCash();
    }

    @Override
    public UserAccount getUserAccountDetail(Long userId) {
        this.logger.debug("\u4ece\u6570\u636e\u5e93\u83b7\u53d6\u7528\u6237\u8d26\u6237\u4fe1\u606f\uff1a\u7528\u6237id:[{}]", (Object)userId);
        return this.getAndSetUserAccount(userId);
    }

    @Override
    public Message createUserAccount(Long userId) {
        this.logger.debug("\u521b\u5efa\u7528\u6237\u8d26\u6237\u4fe1\u606f\uff1a\u7528\u6237id:[{}]", (Object)userId);
        this.getAndSetUserAccount(userId);
        return Message.build();
    }

    @Override
    public void cleanCache(Long userId) {
        this.redisStringAdapter.remove(this.buildCacheKey(userId));
    }

    private KeyGenerator buildCacheKey(Long userId) {
        return RedisConfig.USER_ACCOUNT_CACHE.copy().appendKey((Object)userId);
    }

    @Override
    public UserAccountDTO getUserAccount(Long userId) {
        KeyGenerator key = this.buildCacheKey(userId);
        UserAccountDTO res = (UserAccountDTO)this.redisStringAdapter.get(key, UserAccountDTO.class);
        if (null == res) {
            res = this.convertUserAccount(this.getAndSetUserAccount(userId));
            this.redisStringAdapter.set(key, (Object)res);
        } else if (2 > res.getV()) {
            res = this.convertUserAccount(this.getAndSetUserAccount(userId));
            this.redisStringAdapter.set(key, (Object)res);
        }
        return res;
    }

    @Override
    public UserAccountDTO getUserAccountAndEnableWithdraw(Long userId) {
        return this.getUserAccount(userId);
    }

    @Override
    public UserAccountDayCashDTO getUserAccountAndDetail(Long userId, String areaCode) {
        LocationDTO locationDTO;
        UserWithdrawDTO userWithdrawDTO = this.userWithdrawService.getUserRecentWithdrawInfo(userId);
        if (userWithdrawDTO == null || WithdrawEnum.SUCCESS_PAYMENT.getState().equals(userWithdrawDTO.getStatus()) || WithdrawEnum.FAIL_PAYMENT.getState().equals(userWithdrawDTO.getStatus())) {
            userWithdrawDTO = null;
        }
        UserAccountDTO userAccountDTO = this.getUserAccount(userId);
        if (StringUtils.isNotBlank((CharSequence)areaCode) && !Objects.equals((locationDTO = this.locationIntegrationService.getLocationByGeocode(areaCode)).getEnablePaidPromote(), (byte)1)) {
            userAccountDTO.setNotArriveCash(BigDecimal.ZERO);
        }
        return new UserAccountDayCashDTO(userAccountDTO, this.cashFlowService.getRecentSevenDayCashFlowByUser(userId), userWithdrawDTO);
    }

    @Override
    public UserCashGoldDTO getUserCashGold(Long userId) {
        this.logger.debug("\u83b7\u53d6\u7528\u6237\u8d26\u6237\u5728\u4e2a\u4eba\u4e2d\u5fc3\u7684\u4fe1\u606f\uff1a\u7528\u6237id:[{}]", (Object)userId);
        UserAccountDTO userAccount = this.getUserAccount(userId);
        UserCashGoldDTO userCashGoldDTO = new UserCashGoldDTO(userAccount.getEstimateCash(), userAccount.getUsableGold(), BigDecimal.valueOf(userAccount.getUsableGold().intValue()).divide(this.userProperties.getGoldRate(), 2, 1), userAccount.getTotalGold());
        userCashGoldDTO.setCashFormat(this.convert(userCashGoldDTO.getCash()));
        return userCashGoldDTO;
    }

    private String convert(BigDecimal cash) {
        if (cash == null || cash.compareTo(new BigDecimal(0)) == 0) {
            return "";
        }
        BigDecimal multiple = new BigDecimal("10000");
        if (cash.compareTo(multiple) >= 0) {
            return NumberUtils.format((BigDecimal)cash.divide(multiple)) + "W\u5143";
        }
        multiple = new BigDecimal("1000");
        if (cash.compareTo(multiple) >= 0) {
            return NumberUtils.format((BigDecimal)cash.divide(multiple)) + "K\u5143";
        }
        return NumberUtils.format((BigDecimal)cash) + "\u5143";
    }

    @Override
    public Boolean addCash(final AccountCashParam param) {
        if (null == param || null == param.getUserId() || null == param.getCashType() || null == param.getAddTotal() || null == param.getCash() || param.getCash().compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        this.logger.debug("\u7528\u6237\u8d26\u6237\u91d1\u989d\u66f4\u65b0\uff1a{}", (Object)param);
        AccountActionParam.CashBuilder builder = AccountActionParam.cashBuilder().amount(param.getCash()).userId(param.getUserId()).relationId(param.getRelationId());
        if (StringUtils.isNotBlank((CharSequence)param.getRemake())) {
            builder.remark(param.getRemake());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getCashFlowType())) {
            builder.cashFlowType(CashFlowTypeEnum.valueOf((String)param.getCashFlowType()));
        }
        if (CashEnum.TEMP_CASH.name().equals(param.getCashType())) {
            builder.action(AccountActionEnum.ADD_TEMP_CASH);
        } else if (CashEnum.STABILIZE_CASH.name().equals(param.getCashType())) {
            builder.action(AccountActionEnum.ADD_STABILIZE_CASH);
        } else if (CashEnum.DRAWABLEL_CASH.name().equals(param.getCashType())) {
            builder.action(AccountActionEnum.ADD_DRAWABLE_CASH);
        } else if (CashEnum.SAVE_CASH.name().equals(param.getCashType())) {
            builder.action(AccountActionEnum.ADD_SAVE_CASH);
        }
        if (CashFlowTypeEnum.FAIL_WITHDRAWAL.name().equals(param.getCashFlowType())) {
            builder.action(AccountActionEnum.FAIL_WITHDRAWAL);
        } else if (CashFlowTypeEnum.WECHAT_WITHDRAWAL.name().equals(param.getCashFlowType()) || CashFlowTypeEnum.ALIPAY_WITHDRAWAL.name().equals(param.getCashFlowType())) {
            builder.action(AccountActionEnum.DRAWABLE_TO_WITHDRAWAL);
        }
        try {
            this.accountHandlerProxy.handler(builder.build(), new IAccountActionCallback(){

                @Override
                public void postAction(AccountActionContext context) {
                    if (!CashFlowTypeEnum.RED_PACKET.name().equals(param.getCashFlowType()) && !CashFlowTypeEnum.COMMAND_RED_PACKET.name().equals(param.getCashFlowType()) && AccountActionEnum.ADD_DRAWABLE_CASH.equals((Object)context.getAction())) {
                        UserAccountServiceImpl.this.pushMsgIntegrationService.pushChangeAccountMsg(param);
                    }
                }
            });
        }
        catch (UserAccountException e) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean transferCash(AccountCashParam param) {
        this.logger.debug("\u8f6c\u6362\u7684\u8d26\u6237\u4fe1\u606f\uff1a[{}]", (Object)JSON.toJSONString((Object)param));
        if (null == param || null == param.getUserId() || null == param.getCashType() || null == param.getCash() || null == param.getConvertType() || param.getCash().compareTo(BigDecimal.ZERO) <= 0) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)param.getConvertType())) {
            AccountActionEnum actionEnum = AccountActionEnum.valueOf((String)param.getConvertType());
            this.accountHandlerProxy.handle(AccountActionParam.cashBuilder((AccountActionEnum)actionEnum).userId(param.getUserId()).cashFlowType(CashFlowTypeEnum.valueOf((String)param.getCashFlowType())).amount(param.getCash()).relationId(param.getRelationId()).build());
            return true;
        }
        return false;
    }

    @Override
    public Message updateUserWithdrawInfo(Long userId, BigDecimal amount, Byte state) {
        try {
            if (WithdrawEnum.DURING_PAYMENT.getState().equals(state)) {
                this.accountHandlerProxy.handle(AccountActionParam.cashBuilder((AccountActionEnum)AccountActionEnum.DRAWABLE_TO_WITHDRAWAL).amount(amount).userId(userId).cashFlowType(CashFlowTypeEnum.WITHDRAWAL).build());
            } else if (WithdrawEnum.SUCCESS_PAYMENT.getState().equals(state)) {
                this.accountHandlerProxy.handle(AccountActionParam.cashBuilder((AccountActionEnum)AccountActionEnum.ADD_WITHDRAWAL_CASH).amount(amount).userId(userId).cashFlowType(CashFlowTypeEnum.WITHDRAWAL_SUCCESS).build());
                this.updateInviteUserCash(userId, ExtraInviteStateEnum.WITHDRAW);
            } else if (WithdrawEnum.FAIL_PAYMENT.getState().equals(state)) {
                AccountCashParam accountCashParam = new AccountCashParam(userId, CashEnum.DRAWABLEL_CASH.name(), Boolean.FALSE, amount, null, CashFlowTypeEnum.FAIL_WITHDRAWAL.name(), null);
                this.addCash(accountCashParam);
            }
        }
        catch (UserAccountException e) {
            this.logger.warn("\u63d0\u73b0\u64cd\u4f5c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            return Message.build((boolean)false, (String)e.getMessage());
        }
        return Message.build();
    }

    @Override
    public BigDecimal getUserDrawableCash(Long userId) {
        return this.getUserAccount(userId).getDrawablelCash();
    }

    @Override
    public Boolean addGold(final AccountGoldParam param) {
        this.logger.debug("\u7528\u6237\u8d26\u6237\u66f4\u65b0\u91d1\u5e01\u7684\u53c2\u6570\uff1a[{}]", (Object)param);
        AccountActionParam.GoldBuilder builder = AccountActionParam.goldBuilder().userId(param.getUserId()).goldNum(param.getGold()).content(param.getContent()).reason(param.getReason()).goldFlowType(GoldFlowTypeEnum.valueOf((String)param.getGoldFlowType()));
        if (StringUtils.isNotBlank((CharSequence)param.getReason())) {
            builder.remark(param.getReason());
        }
        if (GoldEnum.TEMP_GOLD.name().equals(param.getGoldType())) {
            builder.action(AccountActionEnum.ADD_TEMP_GOLD);
        } else if (GoldEnum.USABLE_GOLD.name().equals(param.getGoldType())) {
            builder.action(AccountActionEnum.ADD_USABLE_GOLD);
        } else if (GoldEnum.CONSUME_GOLD.name().equals(param.getGoldType())) {
            builder.action(AccountActionEnum.CONSUME_GOLD);
        }
        try {
            this.accountHandlerProxy.handler(builder.build(), new IAccountActionCallback(){

                @Override
                public void postAction(AccountActionContext context) {
                    GoldFlow goldFlow;
                    boolean excludeGoldFlow;
                    boolean bl = excludeGoldFlow = StringUtils.equalsIgnoreCase((CharSequence)GoldFlowTypeEnum.ARTICLE_LIKE_ADD.getName(), (CharSequence)param.getGoldFlowType()) || StringUtils.equalsIgnoreCase((CharSequence)GoldFlowTypeEnum.ARTICLE_LIKE_EXPEND.getName(), (CharSequence)param.getGoldFlowType()) || StringUtils.equalsIgnoreCase((CharSequence)GoldFlowTypeEnum.FLOWER_PRESENT.getName(), (CharSequence)param.getGoldFlowType()) || StringUtils.equalsIgnoreCase((CharSequence)GoldFlowTypeEnum.TASK_NEWS_SHARE.getName(), (CharSequence)param.getGoldFlowType());
                    if (!excludeGoldFlow && null != (goldFlow = context.getGoldFlow(context.getUserId()))) {
                        UserAccountServiceImpl.this.messageUserIntegrationService.addGoldMsg(goldFlow, UserAccountServiceImpl.this.getUserUsableGold(param.getUserId()));
                    }
                }
            });
        }
        catch (UserAccountException e) {
            return false;
        }
        return true;
    }

    @Override
    public Integer getUserUsableGold(Long userId) {
        this.logger.debug("\u83b7\u53d6\u7528\u6237[{}]\u7684\u8d26\u6237\u91d1\u5e01\u53ef\u7528\u4f59\u989d", (Object)userId);
        return this.getUserAccountDetail(userId).getUsableGold();
    }

    @Override
    public void userWithdrawPop(Long userId) {
        this.redisStringAdapter.set(this.getUserWithdrawPop(userId), 1L);
    }

    @Override
    public Json<BigDecimal> userGoldWithdraw(Long userId, String openId, BigDecimal amount, String devcId, String ip) {
        if (this.userProperties.getMixWithdrawBalance().compareTo(amount) > 0 || amount.compareTo(this.userProperties.getMaxWithdrawBalance()) > 0) {
            this.logger.info("\u5f53\u524d\u7528\u6237[{}]\u63d0\u73b0\u91d1\u989d[{}], \u4e0d\u6ee1\u8db3\u63d0\u73b0\u8303\u56f4", (Object)userId, (Object)amount);
            return ResultUtil.genFailedResult((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u63d0\u73b0\u91d1\u989d");
        }
        Integer usableGold = this.getUserUsableGold(userId);
        Integer transferGold = amount.multiply(this.userProperties.getGoldRate()).intValue();
        if (usableGold < transferGold) {
            this.logger.info("\u5f53\u524d\u7528\u6237[{}]\u53ef\u7528\u79ef\u5206[{}]\uff0c\u5c0f\u4e8e\u63d0\u73b0\u79ef\u5206[{}], \u4e0d\u5141\u8bb8\u63d0\u73b0", new Object[]{userId, usableGold, transferGold});
            return ResultUtil.genFailedResult((String)"\u4f59\u989d\u4e0d\u8db3");
        }
        BigDecimal withdrawAmount = this.userWithdrawService.getMiniAppUserWithdraw(userId, openId, WithdrawEnum.SUCCESS_PAYMENT.getState());
        if (this.userProperties.getTodayLimitBalance().compareTo(withdrawAmount) <= 0) {
            this.logger.info("\u7528\u6237[{}]\u4eca\u65e5\u63d0\u73b0\u91d1\u989d\u5df2\u8fbe\u4e0a\u9650", (Object)userId);
            return ResultUtil.genFailedResult((String)"\u5355\u65e5\u5151\u6362\u5df2\u8fbe\u9650\u989d");
        }
        AccountGoldParam param = new AccountGoldParam(userId, "CONSUME_GOLD", Boolean.valueOf(false), transferGold, null, GoldFlowTypeEnum.MINI_APP_WITHDRAW.name());
        if (this.addGold(param).booleanValue()) {
            Message message = this.withdrawIntegrationService.appletWithdraw(userId, openId, amount, devcId, ip);
            if (message.isSuccess()) {
                CashFlow cashFlow = new CashFlow();
                cashFlow.setId(this.nextSequence());
                cashFlow.setUserId(userId);
                cashFlow.setAmount(amount);
                cashFlow.setType(CashFlowTypeEnum.WECHAT_WITHDRAWAL.getName());
                cashFlow.setCreateTime(new Date());
                this.cashFlowService.addCashFlow(cashFlow);
                return ResultUtil.genSuccessResult((Object)amount);
            }
            this.logger.info("\u7528\u6237[{}]\u63d0\u73b0\u5931\u8d25-----\u91d1\u5e01\u9000\u56de", (Object)userId);
            param = new AccountGoldParam(userId, "CONSUME_GOLD", Boolean.valueOf(false), Integer.valueOf(-transferGold.intValue()), null, GoldFlowTypeEnum.WITHDRAW_FAIL_RETURN.name(), null);
            this.addGold(param);
            return ResultUtil.genFailedResult((String)message.getLastMessage());
        }
        return ResultUtil.genFailedResult((String)"\u79ef\u5206\u6263\u9664\u5931\u8d25");
    }

    @Override
    public UserCashInfoVo getUserCashInfo(Long userId) {
        User user;
        UserCashInfoVo userCashInfoVo = new UserCashInfoVo();
        userCashInfoVo.setUserId(userId);
        UserInfoDTO userInfoDTO = this.userService.getUserCache(userId);
        if (null == userInfoDTO) {
            return userCashInfoVo;
        }
        userCashInfoVo.setNickname(userInfoDTO.getNickname());
        userCashInfoVo.setHeadImg(userInfoDTO.getHeadImg());
        UserAccount userAccount = this.userAccountMapper.getUserAccount(userId);
        if (null != userAccount) {
            userCashInfoVo.setCash(userAccount.getTotalCash());
        }
        if (null == (user = this.userService.selectByPrimaryKey(userId)) || user.getInviteUserId() == null) {
            return userCashInfoVo;
        }
        userCashInfoVo.setInviteUserId(user.getInviteUserId());
        UserInfoDTO inviteUserInfoDTO = this.userService.getUserCache(user.getInviteUserId());
        if (null == inviteUserInfoDTO) {
            return userCashInfoVo;
        }
        userCashInfoVo.setInviteUserNickname(inviteUserInfoDTO.getNickname());
        userCashInfoVo.setInviteUserHeadImg(inviteUserInfoDTO.getHeadImg());
        UserAccount inviteUserAccount = this.userAccountMapper.getUserAccount(user.getInviteUserId());
        if (null != inviteUserAccount) {
            userCashInfoVo.setInviteUserCash(inviteUserAccount.getTotalCash());
        }
        return userCashInfoVo;
    }

    private UserAccount generateUserAccount(Long userId) {
        UserAccount userAccount = new UserAccount(userId);
        userAccount.setId(this.nextSequence());
        return userAccount;
    }

    private UserAccountDTO convertUserAccount(UserAccount userAccount) {
        UserAccountDTO accountDTO = new UserAccountDTO();
        BeanUtils.copyProperties((Object)userAccount, (Object)accountDTO);
        accountDTO.setDrawablelCash(userAccount.getDrawableCash());
        accountDTO.setNotArriveCash(userAccount.getTempCash().add(userAccount.getStabilizeCash()));
        if (userAccount.getSettledCash() == null) {
            userAccount.setSettledCash(BigDecimal.ZERO);
        }
        if (userAccount.getNoSettlementCash() == null) {
            userAccount.setNoSettlementCash(BigDecimal.ZERO);
        }
        accountDTO.setEstimateCash(BigDecimal.ZERO.add(userAccount.getSettledCash()).add(userAccount.getNoSettlementCash()));
        accountDTO.setSaveCash(userAccount.getSaveCash());
        return accountDTO;
    }

    private UserAccount getAndSetUserAccount(Long userId) {
        UserAccount userAccount = this.userAccountMapper.getUserAccount(userId);
        if (null == userAccount) {
            this.logger.warn("\u7528\u6237[{}]\u8d26\u6237\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)userId);
            userAccount = this.generateUserAccount(userId);
            if (this.distributedLock.lock(RedisConfig.USER_ACCOUNT_LOCK.appendKey((Object)userId).gen(), userAccount.getId().toString())) {
                this.userAccountMapper.addUserAccount(userAccount);
            }
        } else {
            BigDecimal usableGold = BigDecimal.valueOf(userAccount.getUsableGold().intValue());
            if (usableGold != null && usableGold.compareTo(BigDecimal.ZERO) < 0) {
                userAccount.setUsableGold(Integer.valueOf(0));
            }
        }
        return userAccount;
    }

    private void addUserEvent(Long userId, BigDecimal amount) {
        UserCashGoldDTO userCashGoldDTO = this.getUserCashGold(userId);
        PushPayloadInfo pushPayloadInfo = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.USER_ACCOUNT_ENVET).addExtend("userId", (Object)userId).addExtend("current", (Object)userCashGoldDTO.getCash()).addExtend("val", (Object)amount);
        this.messageSender.sendUserEvent(pushPayloadInfo);
    }

    @Override
    public void updateInviteUserCash(Long userId, ExtraInviteStateEnum currentStateEnum) {
        User user = this.userService.selectByPrimaryKey(userId);
        if (null == user) {
            this.logger.debug("\u7528\u6237\u4e0d\u5b58\u5728\uff0cid\uff1a[{}]", (Object)userId);
            return;
        }
        if (null == user.getInviteUserId()) {
            this.logger.debug("\u7528\u6237[{}]\u7684\u9080\u8bf7\u4eba\u4e3a\u7a7a", (Object)userId);
            return;
        }
        InviteRecord inviteRecord = this.inviteRecordService.getInviteRecordByInvitedUser(user.getInviteUserId(), userId);
        if (null == inviteRecord) {
            this.logger.debug("\u7528\u6237[{}]\u4e0e\u9080\u8bf7\u4eba[{}]\u7684\u5173\u7cfb\u65e0\u6548", (Object)userId, (Object)user.getInviteUserId());
            return;
        }
        if (!InviteRecordStateEnum.LOGIN_APP.getName().equals(inviteRecord.getInviteState())) {
            this.logger.debug("\u5f53\u524d\u9080\u8bf7\u5173\u7cfb\u4e0d\u662f\u5904\u4e8e\u767b\u5f55app\u72b6\u6001----\u4e0d\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c");
            return;
        }
        boolean changeInviteUserCashState = false;
        if (InviteTypeEnum.FACEINVITE.getName().equals(inviteRecord.getType())) {
            Integer inviteState = (Integer)this.redisHashMapAdapter.get(RedisConfig.USER_WITHDRAW_LOGIN_TWICE.copy(), userId.toString(), Integer.class);
            if (null != inviteState) {
                if (ExtraInviteStateEnum.WITHDRAW.equals((Object)currentStateEnum) && ExtraInviteStateEnum.LOGIN_TWICE.getStatus().equals(inviteState) || ExtraInviteStateEnum.LOGIN_TWICE.equals((Object)currentStateEnum) && ExtraInviteStateEnum.WITHDRAW.getStatus().equals(inviteState)) {
                    changeInviteUserCashState = true;
                    this.redisHashMapAdapter.remove(RedisConfig.USER_WITHDRAW_LOGIN_TWICE.copy(), new String[]{userId.toString()});
                }
            } else {
                this.redisHashMapAdapter.put(RedisConfig.USER_WITHDRAW_LOGIN_TWICE.copy(), userId.toString(), (Object)currentStateEnum.getStatus());
            }
        } else {
            changeInviteUserCashState = true;
        }
        if (changeInviteUserCashState) {
            this.logger.info("\u9080\u8bf7\u4eba[{}]\u589e\u52a0\u53ef\u63d0\u73b0\u8d4f\u91d1[{}]", (Object)user.getInviteUserId(), (Object)inviteRecord.getAward());
            inviteRecord.setInviteState(InviteRecordStateEnum.SUCCESS_WITHDRAW.getName());
            inviteRecord.setAwardType(AwardTypeEnum.CASH.name());
            this.inviteRecordService.updateInviteRecord(inviteRecord);
            AccountCashParam accountCashParam = new AccountCashParam(inviteRecord.getUserId(), CashEnum.DRAWABLEL_CASH.name(), Boolean.FALSE, inviteRecord.getAward(), inviteRecord.getId(), CashFlowTypeEnum.PROMOTE_BOUNTY.name(), AccountActionEnum.STABILIZE_TO_DRAWABLE.name());
            this.transferCash(accountCashParam);
        }
    }

    @Override
    public BigDecimal getAccountTempCash(Long userId) {
        return this.userAccountMapper.getAccountTempCash(userId);
    }

    @Override
    public BigDecimal presentFlower(TransformParam transformParam) {
        String name = transformParam.getUserId() + ":" + transformParam.getTargetUserId();
        KeyGenerator queueKeyGenerator = RedisConfig.USER_PRESENT_FLOWER_QUEUE.copy().appendKey((Object)name);
        KeyGenerator processorKeyGenerator = RedisConfig.USER_PRESENT_FLOWER_PROCESSOR.copy();
        this.redisListAdapter.leftPush(queueKeyGenerator, new Object[]{transformParam});
        if (!this.redisSetAdapter.exists(processorKeyGenerator, (Object)name).booleanValue()) {
            this.logger.debug("\u4e0d\u5b58\u5728\u5904\u7406\u5668\uff0c\u521b\u5efa\u5904\u7406\u5668");
            this.redisSetAdapter.add(processorKeyGenerator, new Object[]{name});
            this.redisSetAdapter.expire(processorKeyGenerator, 30L);
            ((ProcessorService)SpringContextHolder.getBean(ProcessorService.class)).doFlowerPresentConsume(transformParam.getUserId(), transformParam.getTargetUserId());
        }
        return BigDecimal.ONE;
    }

    private KeyGenerator getUserWithdrawPop(Long userId) {
        return RedisConfig.USER_WITHDRAW_POP.copy().appendKey((Object)userId);
    }

    @Autowired
    public UserAccountServiceImpl(UserAccountMapper userAccountMapper, DistributedLock distributedLock, CashFlowService cashFlowService, UserWithdrawService userWithdrawService, UserService userService, InviteRecordService inviteRecordService, MessageSender messageSender, RedisStringAdapter redisStringAdapter, PushMsgIntegrationService pushMsgIntegrationService, MessageUserIntegrationService messageUserIntegrationService, UserProperties userProperties, WithdrawIntegrationService withdrawIntegrationService, RedisHashMapAdapter redisHashMapAdapter, RedisListAdapter redisListAdapter, RedisSetAdapter redisSetAdapter, LocationIntegrationService locationIntegrationService, AccountHandlerProxy accountHandlerProxy) {
        this.userAccountMapper = userAccountMapper;
        this.distributedLock = distributedLock;
        this.cashFlowService = cashFlowService;
        this.userWithdrawService = userWithdrawService;
        this.userService = userService;
        this.inviteRecordService = inviteRecordService;
        this.messageSender = messageSender;
        this.redisStringAdapter = redisStringAdapter;
        this.pushMsgIntegrationService = pushMsgIntegrationService;
        this.messageUserIntegrationService = messageUserIntegrationService;
        this.userProperties = userProperties;
        this.withdrawIntegrationService = withdrawIntegrationService;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisListAdapter = redisListAdapter;
        this.redisSetAdapter = redisSetAdapter;
        this.locationIntegrationService = locationIntegrationService;
        this.accountHandlerProxy = accountHandlerProxy;
    }
}

