/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.account.GoldFlowService;
import com.bxm.localnews.user.account.UserAmountService;
import com.bxm.localnews.user.account.UserRewardStatService;
import com.bxm.localnews.user.domain.UserAmountMapper;
import com.bxm.localnews.user.domain.UserRewardStatMapper;
import com.bxm.localnews.user.enums.GoldRewadTypeEnum;
import com.bxm.localnews.user.enums.RewardTypeEnum;
import com.bxm.localnews.user.enums.TaskEnum;
import com.bxm.localnews.user.vo.FlowDetail;
import com.bxm.localnews.user.vo.GoldCoinDetailModel;
import com.bxm.localnews.user.vo.GoldInfoModel;
import com.bxm.localnews.user.vo.MyGold;
import com.bxm.localnews.user.vo.UserAmount;
import com.bxm.localnews.user.vo.UserRewardStat;
import com.bxm.newidea.component.tools.StringUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserRewardStatServiceImpl
implements UserRewardStatService {
    private static final Logger logger = LoggerFactory.getLogger(UserRewardStatServiceImpl.class);
    @Resource
    private UserRewardStatMapper userRewardStatMapper;
    @Resource
    private UserAmountMapper userAmountMapper;
    @Resource
    private UserAmountService userAmountService;
    @Resource
    private GoldFlowService goldFlowService;

    @Override
    public void updateRewardByType(Long userId, Byte taskType, BigDecimal retGold) {
        UserRewardStat stat = this.userRewardStatMapper.selectDailyStat(userId, new Date());
        if (stat == null) {
            stat = UserRewardStat.initUserRewardStat((Long)userId, (Long)this.userAmountMapper.getIdByUserId(userId));
            if (stat.getUserAmountId() == null || stat.getUserAmountId() == 0L) {
                logger.error("[{}]\u6ca1\u6709\u5bf9\u5e94\u7684\u8d26\u53f7\uff08a_user_amount\u8868\u4e2d\u65e0\u8bb0\u5f55\uff09,\u8bf7\u68c0\u67e5\u4e1a\u52a1\u903b\u8f91", (Object)userId);
            } else {
                this.injectValueByTaskType(stat, taskType, retGold, userId);
                this.userRewardStatMapper.insertSelective(stat);
            }
        } else {
            UserRewardStat newStat = new UserRewardStat();
            newStat.setId(stat.getId());
            newStat.setUpdateTime(new Date());
            this.injectValueByTaskType(newStat, taskType, retGold, userId);
            this.userRewardStatMapper.updateRewardByType(newStat);
        }
    }

    private void injectValueByTaskType(UserRewardStat stat, Byte taskType, BigDecimal retGold, Long userId) {
        String[] tableColumnByType = TaskEnum.getTableColumByType((byte)taskType);
        if (null == tableColumnByType) {
            return;
        }
        for (String column : tableColumnByType) {
            try {
                Field field = stat.getClass().getDeclaredField(column);
                field.setAccessible(true);
                if ("tribute".equals(column)) continue;
                field.set(stat, retGold);
            }
            catch (Exception e) {
                logger.info("inject reward value error ", (Throwable)e);
            }
        }
    }

    @Override
    public Json<GoldInfoModel> myGoldStat(Long userId) {
        UserAmount account = this.userAmountService.findAmountByUserId(userId);
        BigDecimal goldYesterday = this.goldFlowService.getYesterdayGold(userId);
        List<FlowDetail> flows = this.goldFlowService.listGoldFlow(userId);
        flows.forEach(e -> {
            if (StringUtils.isNotBlank((CharSequence)e.getContent())) {
                e.setName(e.getContent());
            }
        });
        GoldInfoModel goldInfoModel = new GoldInfoModel(account.getJbBalance(), goldYesterday, flows);
        return ResultUtil.genSuccessResult((Object)goldInfoModel);
    }

    @Override
    public Json<MyGold> myGoldDetail(Long userId) {
        GoldRewadTypeEnum[] values;
        UserRewardStat yesterday = this.userRewardStatMapper.selectRewardDetail(userId);
        MyGold myGold = new MyGold();
        if (yesterday == null) {
            yesterday = new UserRewardStat();
            myGold.setTotalGold(BigDecimal.ZERO);
        } else {
            BigDecimal totalGold = yesterday.getGoldReward() == null ? BigDecimal.ZERO : yesterday.getGoldReward();
            myGold.setTotalGold(totalGold);
        }
        List<GoldCoinDetailModel> detail = new ArrayList<GoldCoinDetailModel>();
        for (GoldRewadTypeEnum typeEnum : values = GoldRewadTypeEnum.values()) {
            detail = this.invokeFieldByType((RewardTypeEnum)typeEnum, yesterday, detail);
        }
        myGold.setGoldDetail(detail);
        return ResultUtil.genSuccessResult((Object)myGold);
    }

    private List<GoldCoinDetailModel> invokeFieldByType(RewardTypeEnum typeEnum, UserRewardStat yesterday, List<GoldCoinDetailModel> detail) {
        Field[] declaredFields = UserRewardStat.class.getDeclaredFields();
        try {
            for (Field field : declaredFields) {
                BigDecimal ret;
                if (!typeEnum.getField().equals(field.getName())) continue;
                field.setAccessible(true);
                Object value = field.get(yesterday);
                if (null == value || !StringUtils.isNotBlank((CharSequence)value.toString()) || (ret = new BigDecimal(value.toString())).compareTo(BigDecimal.ZERO) == 0) continue;
                String desc = typeEnum.getDesc();
                GoldCoinDetailModel detailModel = new GoldCoinDetailModel(desc, ret);
                detail.add(detailModel);
            }
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return detail;
    }
}

