/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.auth.constant.AuthRedisKey;
import com.bxm.localnews.auth.enums.AuthCodeEnum;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.rediskey.UserRedisKey;
import com.bxm.localnews.user.account.VirtualService;
import com.bxm.localnews.user.attribute.UserPersonalInfoService;
import com.bxm.localnews.user.auth.UserAuthCodeService;
import com.bxm.localnews.user.domain.AdminVirtualMapper;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.domain.UserVirtualLoginHistoryMapper;
import com.bxm.localnews.user.domain.VirtualUserMapper;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserVirtualAdminDTO;
import com.bxm.localnews.user.dto.UserVirtualDTO;
import com.bxm.localnews.user.dto.UserVirtualLoginMetaDTO;
import com.bxm.localnews.user.enums.ActivationVipStatusEnum;
import com.bxm.localnews.user.enums.AdminVirtualTypeEnum;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.model.vo.AdminVirtual;
import com.bxm.localnews.user.param.UserVirtualAddParam;
import com.bxm.localnews.user.param.UserVirtualAdminParam;
import com.bxm.localnews.user.param.UserVirtualLoginParam;
import com.bxm.localnews.user.param.UserVirtualParam;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.localnews.user.support.ChannelService;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserVip;
import com.bxm.localnews.user.vo.UserVirtualLoginHistory;
import com.bxm.newidea.component.jwt.tools.JwtTokenUtil;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class VirtualServiceImpl
implements VirtualService {
    private static final Logger log = LoggerFactory.getLogger(VirtualServiceImpl.class);
    private final AdminVirtualMapper adminVirtualMapper;
    private final UserService userService;
    private final UserAuthCodeService userAuthCodeService;
    private final ChannelService channelService;
    private final VirtualUserMapper virtualUserMapper;
    private final SequenceCreater sequenceCreater;
    private final UserMapper userMapper;
    private final UserVipService userVipService;
    private final UserVirtualLoginHistoryMapper userVirtualLoginHistoryMapper;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserProperties userProperties;

    @Override
    public Message virtualToLogin(UserVirtualLoginParam userVisitParam) {
        Boolean exist;
        if (Objects.equals(userVisitParam.getCurrentUserId(), userVisitParam.getTargetUserId())) {
            return Message.build((boolean)false, (String)"\u5f53\u524d\u7528\u6237\u5df2\u767b\u5f55");
        }
        boolean isVirtualUser = true;
        if (Objects.equals(userVisitParam.getTargetUserId(), userVisitParam.getVirtualAdminId())) {
            isVirtualUser = false;
        }
        if (userVisitParam.getVirtualAdminId() == null || userVisitParam.getVirtualAdminId() == 0L) {
            userVisitParam.setVirtualAdminId(userVisitParam.getCurrentUserId());
        }
        if (!Objects.equals(userVisitParam.getVirtualAdminId(), userVisitParam.getTargetUserId()) && !(exist = Boolean.valueOf(this.adminVirtualMapper.existInfoByAdminAndType(userVisitParam.getVirtualAdminId(), AdminVirtualTypeEnum.APP.getType(), userVisitParam.getTargetUserId()))).booleanValue()) {
            return Message.build((boolean)false, (String)"\u8bf7\u5207\u6362\u6b63\u786e\u7684\u8d26\u53f7");
        }
        UserVirtualLoginMetaDTO login = this.login(userVisitParam, isVirtualUser);
        return Message.build((boolean)true).addParam("meta", (Object)login);
    }

    private UserVirtualLoginMetaDTO login(UserVirtualLoginParam userVirtualLoginParam, Boolean isVirtualUser) {
        UserVip userVip;
        User user = this.userMapper.selectByPrimaryKey(userVirtualLoginParam.getTargetUserId());
        UserInfoDTO dto = this.virtualLogin(userVirtualLoginParam, user, isVirtualUser);
        dto.setToken(this.generateToken(user.getId(), null));
        if (isVirtualUser.booleanValue()) {
            dto.setPhone(this.userProperties.getVirtualUserPhone());
        }
        dto.setIsVip(Integer.valueOf(Objects.equals((userVip = this.userVipService.getUserVipByUid(userVirtualLoginParam.getTargetUserId())).getStatus(), ActivationVipStatusEnum.USEFUL.getStatus()) ? 1 : 0));
        if (Objects.equals(userVip.getStatus(), ActivationVipStatusEnum.USEFUL.getStatus())) {
            dto.setLeftActiveNum(userVip.getLeftOpenNum());
        } else {
            dto.setLeftActiveNum(Integer.valueOf(0));
        }
        UserVirtualLoginMetaDTO meta = new UserVirtualLoginMetaDTO(dto);
        meta.setVirtualAdminId(userVirtualLoginParam.getVirtualAdminId());
        meta.setIsVirtualUser(isVirtualUser);
        this.saveVirtualLoginLog(userVirtualLoginParam);
        return meta;
    }

    private String generateToken(Long userId, String token) {
        if (null == token) {
            token = JwtTokenUtil.generateToken((Long)userId);
        }
        this.redisHashMapAdapter.put(UserRedisKey.HASH_USER_TOKEN, String.valueOf(userId), (Object)token);
        return token;
    }

    @Async
    public void saveVirtualLoginLog(UserVirtualLoginParam virtualLoginParam) {
        String phoneType = null;
        if (PlatformEnum.ANDROID.getCode() == virtualLoginParam.getPlatform()) {
            phoneType = PlatformEnum.ANDROID.name();
        }
        if (PlatformEnum.IOS.getCode() == virtualLoginParam.getPlatform()) {
            phoneType = PlatformEnum.IOS.name();
        }
        UserVirtualLoginHistory loginHistory = new UserVirtualLoginHistory();
        loginHistory.setId(this.sequenceCreater.nextLongId());
        loginHistory.setLastLoginIp(virtualLoginParam.getIp());
        loginHistory.setVirtualId(virtualLoginParam.getTargetUserId());
        loginHistory.setVirtualAdminId(virtualLoginParam.getVirtualAdminId());
        loginHistory.setLastLoginTime(new Date());
        loginHistory.setPhoneModel(phoneType);
        loginHistory.setClientVersion(virtualLoginParam.getCurVer());
        loginHistory.setServerVersion(virtualLoginParam.getVersion());
        loginHistory.setOperatingSystem(phoneType);
        loginHistory.setCreateTime(new Date());
        loginHistory.setUpdateTime(new Date());
        this.userVirtualLoginHistoryMapper.insertSelective(loginHistory);
    }

    private UserInfoDTO virtualLogin(UserVirtualLoginParam userVirtualLoginParam, User user, Boolean isVirtualUser) {
        user.setRefreshtoken(JwtTokenUtil.generateToken((Long)user.getId()));
        user.setLastLoginIp(userVirtualLoginParam.getIp());
        user.setLastLoginTime(new Date());
        user.setChannelId(user.getChannelId() == 0L ? this.channelService.getChannelByCode(userVirtualLoginParam.getChnl()).getId() : user.getChannelId());
        user.setInfoCompleteState(((UserPersonalInfoService)SpringContextHolder.getBean(UserPersonalInfoService.class)).initUserInfoCompleteStatus(user));
        user.setRegisterClient(userVirtualLoginParam.getPlatform() + "");
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237[{}]\u5bf9\u5e94\u7684\u72b6\u6001\uff1a[{}]", (Object)user.getId(), (Object)user.getState());
        }
        UserInfoDTO userInfoDetail = this.userService.loadUserToRedis(user.getId());
        this.addAuthInfo(userInfoDetail, isVirtualUser);
        return userInfoDetail;
    }

    private void addAuthInfo(UserInfoDTO userInfo, Boolean isVirtualUser) {
        if (isVirtualUser.booleanValue()) {
            String combineCode = (String)this.redisHashMapAdapter.get(AuthRedisKey.USER_AUTH_CODE, userInfo.getId().toString(), String.class);
            if (combineCode == null) {
                Object[] authCodeArray = BitOperatorUtil.setBitToArray((Long[])new Long[]{0L}, (int)AuthCodeEnum.VIRTUAL_ADMIN_MANAGE.index, (boolean)true);
                String authCombineCode = StringUtils.join((Object[])authCodeArray, (String)",");
                this.redisHashMapAdapter.put(AuthRedisKey.USER_AUTH_CODE, userInfo.getId().toString(), (Object)authCombineCode);
            }
            userInfo.setCombineAuthCode(this.userAuthCodeService.getAuthCombineCode(userInfo.getId()));
            userInfo.setAuthResources(this.userAuthCodeService.getAuthResources(userInfo.getId()));
        } else {
            userInfo.setCombineAuthCode(this.userAuthCodeService.getAuthCombineCode(userInfo.getId()));
            userInfo.setAuthResources(this.userAuthCodeService.getAuthResources(userInfo.getId()));
        }
    }

    @Override
    public List<UserVirtualAdminDTO> getAdminVirtualList(UserVirtualAdminParam userVisitParam) {
        User user;
        if (userVisitParam.getVirtualAdminId() == null || userVisitParam.getVirtualAdminId() == 0L) {
            userVisitParam.setVirtualAdminId(userVisitParam.getUserId());
        }
        if ((user = this.userService.selectByPrimaryKey(userVisitParam.getVirtualAdminId())) == null) {
            return Collections.emptyList();
        }
        UserVirtualAdminDTO userVirtualAdminDTO = new UserVirtualAdminDTO();
        userVirtualAdminDTO.setVirtualHeadImg(user.getHeadImg());
        userVirtualAdminDTO.setVirtualNickName(user.getNickname());
        userVirtualAdminDTO.setVirtualId(user.getId());
        if (userVisitParam.getUserId().equals(userVisitParam.getVirtualAdminId())) {
            userVirtualAdminDTO.setIsLogin(Boolean.valueOf(true));
        } else {
            userVirtualAdminDTO.setIsLogin(Boolean.valueOf(false));
        }
        ArrayList<UserVirtualAdminDTO> adminVirtualList = new ArrayList<UserVirtualAdminDTO>();
        if (userVisitParam.getPageNum() != null && userVisitParam.getPageNum() == 1) {
            adminVirtualList.add(userVirtualAdminDTO);
        }
        Page userVirtualList = PageHelper.startPage((Object)userVisitParam).doSelectPage(() -> this.adminVirtualMapper.getAdminVirtualList(userVisitParam));
        Iterator adminDTOIterator = userVirtualList.iterator();
        while (adminDTOIterator.hasNext()) {
            UserVirtualAdminDTO item = (UserVirtualAdminDTO)adminDTOIterator.next();
            if (userVisitParam.getUserId().equals(item.getVirtualId())) {
                item.setIsLogin(Boolean.valueOf(true));
                adminVirtualList.add(item);
                adminDTOIterator.remove();
                continue;
            }
            item.setIsLogin(Boolean.valueOf(false));
        }
        adminVirtualList.addAll((Collection<UserVirtualAdminDTO>)userVirtualList);
        return adminVirtualList;
    }

    @Override
    public List<UserVirtualDTO> getVirtualList(UserVirtualParam userVisitParam) {
        if (userVisitParam.getVirtualAdminId() == null || userVisitParam.getVirtualAdminId() == 0L) {
            userVisitParam.setVirtualAdminId(userVisitParam.getUserId());
        }
        Page userVirtualList = PageHelper.startPage((Object)userVisitParam).doSelectPage(() -> this.adminVirtualMapper.getVirtualList(userVisitParam));
        return userVirtualList;
    }

    @Override
    public Boolean addVirtualToAdminAccount(UserVirtualAddParam userVisitParam) {
        boolean existVirtualUser;
        if (userVisitParam.getVirtualAdminId() == null || userVisitParam.getVirtualAdminId() == 0L) {
            userVisitParam.setVirtualAdminId(userVisitParam.getUserId());
        }
        if (!(existVirtualUser = this.virtualUserMapper.existVirtualUser(userVisitParam.getVirtualId()))) {
            log.error("\u9a6c\u7532\u53f7\u4fe1\u606f\u4e0d\u5b58\u5728 id\uff1a{}", (Object)userVisitParam.getVirtualId());
            return Boolean.FALSE;
        }
        UserInfoDTO userCache = this.userService.getUserCache(userVisitParam.getVirtualAdminId());
        if (userCache == null || userCache.getState().equals((byte)3)) {
            log.error("\u9a6c\u7532\u53f7\u7ba1\u7406\u5458\u4fe1\u606f\u4e0d\u5b58\u5728 id\uff1a{}", (Object)userVisitParam.getVirtualAdminId());
            return Boolean.FALSE;
        }
        AdminVirtual adminVirtual = new AdminVirtual();
        adminVirtual.setAddTime(new Date());
        adminVirtual.setAdminType(AdminVirtualTypeEnum.APP.getType());
        adminVirtual.setAdminUserId(userVisitParam.getVirtualAdminId());
        adminVirtual.setVirtualUserId(userVisitParam.getVirtualId());
        adminVirtual.setId(this.sequenceCreater.nextLongId());
        adminVirtual.setOperateUserId(userVisitParam.getVirtualAdminId());
        adminVirtual.setOperateUserAccount(userCache.getNickname());
        adminVirtual.setAdminUserAccount(userCache.getNickname());
        int result = 0;
        try {
            result = this.adminVirtualMapper.insertSelective(adminVirtual);
        }
        catch (Exception e) {
            log.error("\u7ba1\u7406\u5458\u6dfb\u52a0\u9a6c\u7532\u53f7\u5931\u8d25 \u8bf7\u6c42json\uff1a{}", (Object)JSON.toJSONString((Object)userVisitParam), (Object)e);
        }
        if (result > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public VirtualServiceImpl(AdminVirtualMapper adminVirtualMapper, UserService userService, UserAuthCodeService userAuthCodeService, ChannelService channelService, VirtualUserMapper virtualUserMapper, SequenceCreater sequenceCreater, UserMapper userMapper, UserVipService userVipService, UserVirtualLoginHistoryMapper userVirtualLoginHistoryMapper, RedisHashMapAdapter redisHashMapAdapter, UserProperties userProperties) {
        this.adminVirtualMapper = adminVirtualMapper;
        this.userService = userService;
        this.userAuthCodeService = userAuthCodeService;
        this.channelService = channelService;
        this.virtualUserMapper = virtualUserMapper;
        this.sequenceCreater = sequenceCreater;
        this.userMapper = userMapper;
        this.userVipService = userVipService;
        this.userVirtualLoginHistoryMapper = userVirtualLoginHistoryMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userProperties = userProperties;
    }
}

