/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.attribute.impl;

import com.bxm.localnews.user.attribute.UserFunsService;
import com.bxm.localnews.user.domain.UserFunsMapper;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.enums.UserFollowStatusEnum;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.vo.UserFuns;
import com.bxm.localnews.user.vo.UserFunsRecord;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserFunsServiceImpl
implements UserFunsService {
    private final UserFunsMapper userFunsMapper;
    private final SequenceCreater sequenceCreater;
    private final UserService userService;

    @Autowired
    public UserFunsServiceImpl(UserFunsMapper userFunsMapper, SequenceCreater sequenceCreater, UserService userService) {
        this.userFunsMapper = userFunsMapper;
        this.sequenceCreater = sequenceCreater;
        this.userService = userService;
    }

    @Override
    public void addFuns(Long userId, Long funsId, byte type) {
        UserFunsRecord funs = new UserFunsRecord();
        funs.setUserId(userId);
        funs.setFunsUserId(funsId);
        funs.setType(Byte.valueOf(type));
        int update = this.userFunsMapper.update(funs);
        if (0 == update) {
            funs.setId(this.sequenceCreater.nextLongId());
            this.userFunsMapper.insert(funs);
        }
    }

    @Override
    public void removeFuns(Long userId, Long funsId) {
        UserFunsRecord funs = new UserFunsRecord();
        funs.setUserId(userId);
        funs.setFunsUserId(funsId);
        funs.setType(Byte.valueOf(UserFollowStatusEnum.UNFOLLOW.getCode()));
        this.userFunsMapper.update(funs);
    }

    @Override
    public void setFuns(Long userId, Long funsId, byte type) {
        UserFunsRecord funs = new UserFunsRecord();
        funs.setUserId(userId);
        funs.setFunsUserId(funsId);
        funs.setType(Byte.valueOf(type));
        this.userFunsMapper.update(funs);
    }

    @Override
    public List<UserFuns> getUserFuns(List<Long> userIdList) {
        ArrayList<UserFuns> resultList = new ArrayList<UserFuns>();
        if (CollectionUtils.isEmpty(userIdList)) {
            return resultList;
        }
        for (Long userId : userIdList) {
            List<Long> funsUserIdList;
            List<UserInfoDTO> funsUserList;
            List userFuns = this.userFunsMapper.getFunsListByUserId(userId);
            if (CollectionUtils.isEmpty((Collection)userFuns) || CollectionUtils.isEmpty(funsUserList = this.userService.getBatchUserInfo(funsUserIdList = userFuns.stream().map(UserFuns::getFunsUserId).collect(Collectors.toList())))) continue;
            HashMap<Long, String> userAreaMap = new HashMap<Long, String>();
            for (UserInfoDTO userInfoDTO : funsUserList) {
                userAreaMap.put(userInfoDTO.getId(), userInfoDTO.getLocationCode());
            }
            for (UserFuns userFun : userFuns) {
                userFun.setFunsAreaCode((String)userAreaMap.get(userFun.getFunsUserId()));
                resultList.add(userFun);
            }
        }
        return resultList;
    }
}

