/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.auth.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.auth.constant.AuthRedisKey;
import com.bxm.localnews.auth.enums.AuthCodeEnum;
import com.bxm.localnews.auth.enums.RoleCodeEnum;
import com.bxm.localnews.mq.common.constant.UserEventEnum;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.localnews.user.auth.UserAuthCodeService;
import com.bxm.localnews.user.domain.auth.UserAuthCodeMapper;
import com.bxm.localnews.user.domain.auth.UserAuthIdMapper;
import com.bxm.localnews.user.domain.auth.UserRoleAuthMapper;
import com.bxm.localnews.user.domain.auth.UserRoleMapper;
import com.bxm.localnews.user.dto.auth.UserAuthResourceDto;
import com.bxm.localnews.user.param.RemoveAuthCodeParam;
import com.bxm.localnews.user.timer.RemoveUserAuthTask;
import com.bxm.localnews.user.vo.auth.UserAuthCodeBean;
import com.bxm.localnews.user.vo.auth.UserAuthIdBean;
import com.bxm.localnews.user.vo.auth.UserRoleAuthBean;
import com.bxm.localnews.user.vo.auth.UserRoleBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.builder.OnceTask;
import com.bxm.newidea.component.schedule.builder.OnceTaskBuilder;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserAuthCodeServiceImpl
extends BaseService
implements UserAuthCodeService {
    private static final Logger log = LoggerFactory.getLogger(UserAuthCodeServiceImpl.class);
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserAuthCodeMapper userAuthCodeMapper;
    private final UserAuthIdMapper userAuthIdMapper;
    private final UserRoleAuthMapper userRoleAuthMapper;
    private final UserRoleMapper userRoleMapper;
    private final MessageSender messageSender;
    private final ScheduleService scheduleService;
    private final RemoveUserAuthTask removeUserAuthTask;
    private TypeReference<List<String>> typeReference = new TypeReference<List<String>>(){};

    @Autowired
    public UserAuthCodeServiceImpl(RedisHashMapAdapter redisHashMapAdapter, UserAuthCodeMapper userAuthCodeMapper, UserAuthIdMapper userAuthIdMapper, UserRoleAuthMapper userRoleAuthMapper, UserRoleMapper userRoleMapper, MessageSender messageSender, ScheduleService scheduleService, RemoveUserAuthTask removeUserAuthTask) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userAuthCodeMapper = userAuthCodeMapper;
        this.userAuthIdMapper = userAuthIdMapper;
        this.userRoleAuthMapper = userRoleAuthMapper;
        this.userRoleMapper = userRoleMapper;
        this.messageSender = messageSender;
        this.scheduleService = scheduleService;
        this.removeUserAuthTask = removeUserAuthTask;
    }

    @Override
    public Long[] getAuthCombineCode(Long userId) {
        Long[] authCodeArray;
        String combineCode = (String)this.redisHashMapAdapter.get(AuthRedisKey.USER_AUTH_CODE, userId.toString(), String.class);
        if (null == combineCode) {
            authCodeArray = new Long[]{0L};
        } else {
            String[] authCodeStrArray = combineCode.split(",");
            authCodeArray = new Long[authCodeStrArray.length];
            for (int i = 0; i < authCodeStrArray.length; ++i) {
                authCodeArray[i] = Long.valueOf(authCodeStrArray[i]);
            }
        }
        return authCodeArray;
    }

    @Override
    public List<UserAuthResourceDto> getAuthResources(Long userId) {
        Map<String, List<String>> authResourceMap = this.redisHashMapAdapter.entries(this.buildKey(userId), this.typeReference);
        if (null == authResourceMap) {
            authResourceMap = this.reloadResourceIdCache(userId);
        }
        return authResourceMap.entrySet().stream().map(entry -> new UserAuthResourceDto(Integer.valueOf((String)entry.getKey()), (List)entry.getValue())).collect(Collectors.toList());
    }

    private Map<String, List<String>> reloadResourceIdCache(Long userId) {
        HashMap cacheMap = Maps.newHashMap();
        List userAuthIdBeans = this.userAuthIdMapper.queryAuthIds(userId);
        userAuthIdBeans.forEach(item -> {
            String key = item.getAuthCode() + "";
            List resourceIds = (List)cacheMap.get(key);
            if (null == resourceIds) {
                resourceIds = Lists.newArrayList();
            }
            resourceIds.add(item.getAuthId());
            cacheMap.put(key, resourceIds);
        });
        KeyGenerator key = this.buildKey(userId);
        this.redisHashMapAdapter.remove(key);
        this.redisHashMapAdapter.putAll(key, (Map)cacheMap);
        return cacheMap;
    }

    private void sendUserReloadEvent(Long userId) {
        this.messageSender.sendUserEvent(PushPayloadInfo.build().setType(UserEventEnum.AUTH_CHANGE.type).addExtend("userId", (Object)userId));
    }

    @Override
    public Message addRole(Long userId, RoleCodeEnum role) {
        Preconditions.checkArgument((null != role ? 1 : 0) != 0);
        UserRoleBean roleBean = new UserRoleBean();
        roleBean.setId(Long.valueOf(this.nextId()));
        roleBean.setCreateTime(new Date());
        roleBean.setRoleCode(role.name());
        roleBean.setUserId(userId);
        this.userRoleMapper.insert(roleBean);
        List authBeans = this.userRoleAuthMapper.queryByCode(role.name());
        Long[] authCombineCode = this.getAuthCombineCode(userId);
        for (UserRoleAuthBean userRoleAuth : authBeans) {
            AuthCodeEnum codeEnum = AuthCodeEnum.getByIndex((Integer)userRoleAuth.getAuthCode());
            authCombineCode = this.changeUserAuthCode(authCombineCode, codeEnum, true);
        }
        Message message = this.saveAuthCode(authCombineCode, userId);
        this.sendUserReloadEvent(userId);
        return message;
    }

    @Override
    public Message removeRole(Long userId, RoleCodeEnum role) {
        Preconditions.checkArgument((null != role ? 1 : 0) != 0);
        Preconditions.checkArgument((null != userId ? 1 : 0) != 0);
        this.userRoleMapper.removeUserRole(userId, role.name());
        List authBeans = this.userRoleAuthMapper.queryByCode(role.name());
        Long[] authCombineCode = this.getAuthCombineCode(userId);
        for (UserRoleAuthBean userRoleAuth : authBeans) {
            AuthCodeEnum codeEnum = AuthCodeEnum.getByIndex((Integer)userRoleAuth.getAuthCode());
            authCombineCode = this.changeUserAuthCode(authCombineCode, codeEnum, false);
        }
        MybatisBatchBuilder.create(UserAuthIdMapper.class, (Collection)authBeans).run((mapper, auth) -> mapper.removeAuth(userId, auth.getAuthCode()));
        this.reloadResourceIdCache(userId);
        this.sendUserReloadEvent(userId);
        return this.saveAuthCode(authCombineCode, userId);
    }

    @Override
    public Message addAuthCode(Long userId, AuthCodeEnum authCode) {
        Long[] authCombineCode = this.getAuthCombineCode(userId);
        authCombineCode = this.changeUserAuthCode(authCombineCode, authCode, true);
        return this.saveAuthCode(authCombineCode, userId);
    }

    private Message saveAuthCode(Long[] authCodeArray, Long userId) {
        int rows;
        String authCombineCode = StringUtils.join((Object[])authCodeArray, (String)",");
        this.redisHashMapAdapter.put(AuthRedisKey.USER_AUTH_CODE, userId.toString(), (Object)authCombineCode);
        UserAuthCodeBean entity = this.userAuthCodeMapper.queryByUserId(userId);
        if (entity == null) {
            entity = new UserAuthCodeBean();
            entity.setId(Long.valueOf(this.nextId()));
            entity.setCreateTime(new Date());
            entity.setAuthCombineCode(authCombineCode);
            entity.setUserId(userId);
            rows = this.userAuthCodeMapper.insert(entity);
        } else {
            entity.setAuthCombineCode(authCombineCode);
            entity.setModifyTime(new Date());
            rows = this.userAuthCodeMapper.updateByPrimaryKey(entity);
        }
        this.sendUserReloadEvent(userId);
        return Message.build((int)rows);
    }

    private Long[] changeUserAuthCode(Long[] authCombineCode, AuthCodeEnum authCode, boolean isAdd) {
        return BitOperatorUtil.setBitToArray((Long[])authCombineCode, (int)authCode.index, (boolean)isAdd);
    }

    @Override
    public Message removeAuthCode(Long userId, AuthCodeEnum authCode) {
        Long[] authCombineCode = this.getAuthCombineCode(userId);
        authCombineCode = this.changeUserAuthCode(authCombineCode, authCode, false);
        this.userAuthIdMapper.removeAuth(userId, Integer.valueOf(authCode.index));
        this.redisHashMapAdapter.remove(this.buildKey(userId), new String[]{authCode.index + ""});
        return this.saveAuthCode(authCombineCode, userId);
    }

    @Override
    public Message addResource(Long userId, AuthCodeEnum authCode, String resourceId) {
        return this.addResource(userId, authCode, (List<String>)ImmutableList.of((Object)resourceId));
    }

    @Override
    public Boolean hasAuth(Long userId, AuthCodeEnum codeEnum) {
        int authCode = codeEnum.index;
        Long[] parseAuthCodeArray = this.getAuthCombineCode(userId);
        return BitOperatorUtil.hasBit((Long[])parseAuthCodeArray, (int)authCode);
    }

    @Override
    public Message removeResource(Long userId, AuthCodeEnum authCode, String resourceId) {
        String subKey;
        KeyGenerator key = this.buildKey(userId);
        List resources = (List)this.redisHashMapAdapter.get(key, subKey = String.valueOf(authCode.index), this.typeReference);
        if (null != resources) {
            resources.remove(resourceId);
            this.redisHashMapAdapter.put(key, subKey, (Object)resources);
        }
        Message message = Message.build((int)this.userAuthIdMapper.removeAuthId(userId, Integer.valueOf(authCode.index), resourceId));
        this.sendUserReloadEvent(userId);
        return message;
    }

    @Override
    public Message addResource(Long userId, AuthCodeEnum authCode, List<String> resources) {
        Preconditions.checkArgument((null != resources ? 1 : 0) != 0);
        KeyGenerator key = this.buildKey(userId);
        String subKey = String.valueOf(authCode.index);
        List existsResources = (List)this.redisHashMapAdapter.get(key, subKey, this.typeReference);
        if (null == existsResources) {
            existsResources = Lists.newArrayList();
        }
        existsResources.addAll(resources);
        this.redisHashMapAdapter.put(key, subKey, (Object)existsResources);
        ArrayList userAuthIdBeans = Lists.newArrayList();
        Date now = new Date();
        for (String resource : resources) {
            UserAuthIdBean entity = new UserAuthIdBean();
            entity.setAuthCode(Integer.valueOf(authCode.index));
            entity.setId(Long.valueOf(this.nextId()));
            entity.setAuthId(resource);
            entity.setUserId(userId);
            entity.setCreateTime(now);
            userAuthIdBeans.add(entity);
        }
        boolean success = MybatisBatchBuilder.create(UserAuthIdMapper.class, (Collection)userAuthIdBeans).run(UserAuthIdMapper::insert);
        this.sendUserReloadEvent(userId);
        return Message.build((boolean)success);
    }

    @Override
    public Message addRemoveAuthCodeTask(RemoveAuthCodeParam param) {
        OnceTask task = OnceTaskBuilder.builder((String)RemoveUserAuthTask.generateTaskName(param.getUserId()), (Date)param.getExpireTime(), (TaskCallback)this.removeUserAuthTask).callbackParam((Object)param).build();
        return Message.build((boolean)this.scheduleService.push((ScheduleTask)task));
    }

    @Override
    public Message removeAuthCodeTask(Long userId) {
        this.logger.debug("\u5220\u9664\u79fb\u9664\u7528\u6237\u6743\u9650\u5b9a\u65f6\u4efb\u52a1\u6210\u529f,taskName:[{}]", (Object)RemoveUserAuthTask.generateTaskName(userId));
        return Message.build((boolean)this.scheduleService.remove(RemoveUserAuthTask.generateTaskName(userId)));
    }

    private KeyGenerator buildKey(Long userId) {
        return AuthRedisKey.USER_AUTH_RESOURCE.copy().appendKey((Object)userId.toString());
    }
}

